#include "tsummarydata.h"

//******************************************************************************
//                              TSummaryData
//******************************************************************************

TSummaryData::TSummaryData(time_t regtime) {
    sds.regtime = static_cast<ui32>(regtime);
}

TSummaryData::TSummaryData(time_t regtime, TString& prefix_login, TString& first_nsymb_login, TString& /*email*/, TString& /*nickname*/, TString& phone, ui64 useragent, ui64 reserv1, ui64 reserv2, ui64 reserv3) {
    sds.regtime = static_cast<ui32>(regtime);
    sds.prefix_login = prefix_login;
    sds.first_nsymb_login = first_nsymb_login;
    if (!phone.empty())
        sds.est_phone = true;
    sds.useragent1 = useragent;
    sds.reserv1 = reserv1;
    sds.reserv2 = reserv2;
    sds.reserv3 = reserv3;
}

bool TSummaryData::operator==(const TSummaryData& value) const {
    bool res = false;

    if ((sds.regtime == value.sds.regtime) &&
        (sds.prefix_login == value.sds.prefix_login) &&
        (sds.first_nsymb_login == value.sds.first_nsymb_login) &&
        (sds.est_phone == value.sds.est_phone) &&
        (sds.useragent1 == value.sds.useragent1) &&
        (sds.reserv1 == value.sds.reserv1) &&
        (sds.reserv2 == value.sds.reserv2) &&
        (sds.reserv3 == value.sds.reserv3))
        res = true;

    return res;
}

bool TSummaryData::operator<(const TSummaryData& value) const {
    return (sds.regtime < value.sds.regtime);
}

bool TSummaryData::operator<=(const TSummaryData& value) const {
    return (sds.regtime <= value.sds.regtime);
}

bool TSummaryData::operator>(const TSummaryData& value) const {
    return (sds.regtime > value.sds.regtime);
}

bool TSummaryData::operator>=(const TSummaryData& value) const {
    return (sds.regtime >= value.sds.regtime);
}

//******************************************************************************
//                           TSummaryDataArray
//******************************************************************************

TSummaryDataArray::TSummaryDataArray() {
    Init();
}

TSummaryDataArray::TSummaryDataArray(const TSummaryData& sd) {
    Init();
    data.push_back(sd);
    data.sort();
}

void TSummaryDataArray::Lock() {
    m_Mutex.Acquire();
}

void TSummaryDataArray::UnLock() {
    m_Mutex.Release();
}

void TSummaryDataArray::Init() {
    Lock();

    data.clear();

    UnLock();
}

void TSummaryDataArray::Clear() {
    Init();
}

void TSummaryDataArray::Update(const TSummaryDataArray& Stat) {
    Lock();

    auto it = Stat.data.begin();
    while (it != Stat.data.end()) {
        data.push_back(*it);
        ++it;
    }

    data.sort();

    UnLock();
}

ui32 TSummaryDataArray::GetCount() {
    ui32 res = 0;

    Lock();

    res = static_cast<ui32>(data.size());

    UnLock();

    return res;
}

size_t TSummaryDataArray::size() const {
    size_t res = 0;
    TSDListCIt it;
    ui32 sizecount = 0;

    it = data.begin();
    while (it != data.end()) {
        sizecount = 0;
        sizecount += sizeof(ui16); //size prefix_login
        sizecount += (*it).sds.prefix_login.size();
        sizecount += sizeof(ui16); //size first_nsymb_login
        sizecount += (*it).sds.first_nsymb_login.size();
        //sizecount += sizeof((*it).sds.pack1);
        //sizecount += sizeof((*it).sds.est_email);
        //sizecount += sizeof((*it).sds.est_nickname);
        sizecount += sizeof((*it).sds.regtime);
        sizecount += sizeof((*it).sds.est_phone);
        sizecount += sizeof((*it).sds.useragent1);
        sizecount += sizeof((*it).sds.reserv1);
        sizecount += sizeof((*it).sds.reserv2);
        sizecount += sizeof((*it).sds.reserv3);

        res += sizecount;
        ++it;
    }

    return res;
}

TLTCSum TSummaryDataArray::GetCountFromNew(time_t current_time, const TString& prefix_loginA, const TString& first_nsymb_loginA, bool del, ui64 useragentA, ui64 reserv1, ui64 reserv2, ui64 reserv3) {
    TLTCSum res;

    TSummaryData lt_curr(current_time);
    TSummaryData lt_300(current_time - 300);
    TSummaryData lt_1200(current_time - 1200);
    TSDListRIt rit;
    bool flag_300, flag_1200;
    TSDList datanew;

    Lock();

    rit = data.rbegin();
    while (rit != data.rend()) {
        flag_300 = false;
        flag_1200 = false;
        if (((*rit) > lt_300) && ((*rit) <= lt_curr)) {
            if ((*rit).sds.est_phone)
                res.stat_300.est_phone_count++;
            if ((*rit).sds.prefix_login == prefix_loginA)
                res.stat_300.equal_prefix_login_count++;
            if ((*rit).sds.first_nsymb_login == first_nsymb_loginA)
                res.stat_300.equal_first_nsymb_count++;
            if ((*rit).sds.useragent1 == useragentA)
                res.stat_300.equal_useragent_count++;
            if ((*rit).sds.reserv1 == reserv1)
                res.stat_300.equal_reserv1_count++;
            if ((*rit).sds.reserv2 == reserv2)
                res.stat_300.equal_reserv2_count++;
            if ((*rit).sds.reserv3 == reserv3)
                res.stat_300.equal_reserv3_count++;
            flag_300 = true;
        }
        if (((*rit) > lt_1200) && ((*rit) <= lt_curr)) {
            if ((*rit).sds.est_phone)
                res.stat_1200.est_phone_count++;
            if ((*rit).sds.prefix_login == prefix_loginA)
                res.stat_1200.equal_prefix_login_count++;
            if ((*rit).sds.first_nsymb_login == first_nsymb_loginA)
                res.stat_1200.equal_first_nsymb_count++;
            if ((*rit).sds.useragent1 == useragentA)
                res.stat_1200.equal_useragent_count++;
            if ((*rit).sds.reserv1 == reserv1)
                res.stat_1200.equal_reserv1_count++;
            if ((*rit).sds.reserv2 == reserv2)
                res.stat_1200.equal_reserv2_count++;
            if ((*rit).sds.reserv3 == reserv3)
                res.stat_1200.equal_reserv3_count++;

            flag_1200 = true;
        }
        if ((!flag_300) && (!flag_1200))
            break;

        if ((del))
            datanew.push_front(*rit);

        ++rit;
    }

    data = std::move(datanew);

    UnLock();

    return res;
}
