#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include "util/generic/hash_set.h"
#include "util/system/mutex.h"
#include "ktypes.h"
#include "tpackets.h"
#include "tkclasses.h"

//******************************************************************************
//                           TSummaryData
//******************************************************************************

struct TLastTimeCounters {
    TLastTimeCounters() = default;
    ui32 est_phone_count{};
    ui32 equal_prefix_login_count{};
    ui32 equal_first_nsymb_count{};
    ui32 equal_useragent_count{};
    ui32 equal_reserv1_count{};
    ui32 equal_reserv2_count{};
    ui32 equal_reserv3_count{};
};

struct TLTCSum {
    TLTCSum() = default;
    TLastTimeCounters stat_300{};
    TLastTimeCounters stat_1200{};
};

struct TSummaryDataStruct {
    TString prefix_login;
    TString first_nsymb_login;
    ui32 regtime{};
    bool est_phone{};
    ui64 useragent1{};
    ui64 reserv1{};
    ui64 reserv2{};
    ui64 reserv3{};

    Y_SAVELOAD_DEFINE(
        prefix_login,
        first_nsymb_login,
        regtime,
        est_phone,
        useragent1,
        reserv1,
        reserv2,
        reserv3
        )

    TSummaryDataStruct() = default;
};

class TSummaryData {
public:
    TSummaryDataStruct sds;

public:
    Y_SAVELOAD_DEFINE(sds)
    TSummaryData() = default;
    explicit TSummaryData(time_t regtime);
    TSummaryData(time_t regtime, TString& prefix_login, TString& first_nsymb_login, TString& email, TString& nickname, TString& phone, ui64 useragent, ui64 reserv1, ui64 reserv2, ui64 reserv3);

    TSummaryData(const TSummaryData&) = default;
    TSummaryData& operator=(const TSummaryData&) = default;

    bool operator==(const TSummaryData& value) const;
    bool operator<(const TSummaryData& value) const;
    bool operator<=(const TSummaryData& value) const;
    bool operator>(const TSummaryData& value) const;
    bool operator>=(const TSummaryData& value) const;
    explicit operator size_t() const {
        return sizeof(TSummaryData);
    }
};

typedef std::list<TSummaryData> TSDList;
typedef TSDList::iterator TSDListIt;
typedef TSDList::reverse_iterator TSDListRIt;
typedef TSDList::const_iterator TSDListCIt;

class TSummaryDataArray : public TBaseTClass {
private:
    TSDList data;
    mutable TMutex m_Mutex;

    void Lock() override;
    void UnLock() override;
    //void               Lock() const;
    //void               UnLock() const;
public:
    Y_SAVELOAD_DEFINE(data)
    TSummaryDataArray();
    explicit TSummaryDataArray(const TSummaryData& sd);

    void Init();
    void Clear();
    void Update(const TSummaryDataArray& Stat);
    ui32 GetCount();
    size_t size() const override;

    TLTCSum GetCountFromNew(time_t current_time, const TString& prefix_loginA, const TString& first_nsymb_loginA, bool del, ui64 useragentA, ui64 reserv1, ui64 reserv2, ui64 reserv3);
};

//***************************************************************************************************************
