#include "tsymbolsclass.h"

TSymbolSKClass::TSymbolSKClass()
{
   char symb     = 0;
   bool is_vowel = false;
   bool is_digit = false;

   memset(symb_array, 0, sizeof(symb_array));
   for (int i = 0; i < 256; i++)
   {
      symb     = 0;
      is_vowel = false;
      is_digit = false;
      switch (i)
      {
      case 'a':
      case 'o':
      case 'u':
      case 'i':
      case 'e':
      case 'y':
      case 'A':
      case 'O':
      case 'U':
      case 'I':
      case 'E':
      case 'Y':
                        SET_SYMB_VOWEL(symb);
                        SET_SYMB_LAT(symb);
                        is_vowel = true;
                        break;
            case 168: //� - 168
            case 192: //� - 192
            case 197: //� - 197
            case 200: //� - 200
            case 206: //� - 206
            case 211: //� - 211
            case 219: //� - 219
            case 221: //� - 221
            case 222: //� - 222
            case 223: //� - 223
            case 184: //� - 184
            case 224: //� - 224
            case 229: //� - 229
            case 232: //� - 232
            case 238: //� - 238
            case 243: //� - 243
            case 251: //� - 251
            case 253: //� - 253
            case 254: //� - 254
            case 255: //� - 255
                  SET_SYMB_VOWEL(symb);
                        SET_SYMB_CYRILLIC(symb);
                        is_vowel = true;
              break;
  };

      if (!is_vowel)
      {
         if ((i >= '0') && (i <= '9'))
         {
            SET_SYMB_DIGIT(symb);
            is_digit = true;
         }
      }

      if ( (!is_vowel) && (!is_digit) )
      {
         if ( ((i >= 'A') && (i <= 'Z')) || ((i >= 'a') && (i <= 'z')) )
         {
            SET_SYMB_CONST(symb);
            SET_SYMB_LAT(symb);

         } else if ( ((i >= 192) && (i <= 223)) || ((i >= 224) && (i <= 255)) )     //� .. � (��� "�"), � .. � (��� "�")
         {
            SET_SYMB_CONST(symb);
            SET_SYMB_CYRILLIC(symb);
         }
      }

      symb_array[i] = symb;
   }

}

TSymbolSKClass::~TSymbolSKClass()
{

}

bool TSymbolSKClass::IsVowel(char symb)
{
   bool          res = false;
   unsigned char uc = 0;
   char          tc = 0;

   memcpy(&uc, &symb, sizeof(symb));
   tc = symb_array[uc];
   res = IS_SYMB_VOWEL(symb_array[uc]);

   return res;
}

bool TSymbolSKClass::IsConstanant(char symb)
{
   bool          res = false;
   unsigned char uc = 0;

   memcpy(&uc, &symb, sizeof(symb));
   res = IS_SYMB_CONST(symb_array[uc]);

   return res;
}

bool TSymbolSKClass::IsLatin(char symb)
{
   bool          res = false;
   unsigned char uc = 0;

   memcpy(&uc, &symb, sizeof(symb));
   res = IS_SYMB_LAT(symb_array[uc]);

   return res;
}

bool TSymbolSKClass::IsCyrillic(char symb)
{
   bool          res = false;
   unsigned char uc = 0;

   memcpy(&uc, &symb, sizeof(symb));
   res = IS_SYMB_CYRILLIC(symb_array[uc]);

   return res;
}

bool TSymbolSKClass::IsDigit(char symb)
{
   bool          res = false;
   unsigned char uc = 0;

   memcpy(&uc, &symb, sizeof(symb));
   res = IS_SYMB_DIGIT(symb_array[uc]);

   return res;
}

TString TSymbolSKClass::Normaliz01(const TString &text)
{
   //������������ ������:
   //v - ������� (lat)
   //V - ������� (kyrillic)
   //c - ��������� (lat)
   //C - ��������� (kyrillic)
   //d - ���� ��� ��������� ��������������� ������ ���� (lat)
   //D - ���� ��� ��������� ��������������� ������ ���� (kyrillic)
   //o - ������ ������ (lat)
   //O - ������ ������ (kyrillic)
   TString res        = "";
   bool   last_digit = false;
   char   symb       = 0;

   if (!text.empty())
   {
      for (size_t i = 0; i < text.length(); i++)
      {
         symb = text[i];

         if (IsVowel(symb))
         {
               if (IsLatin(symb))
                  res = res + "v";
               else if (IsCyrillic(symb))
                  res = res + "V";

               last_digit = false;

         } else if (IsConstanant(symb))
         {
               if (IsLatin(symb))
                  res = res + "c";
               else if (IsCyrillic(symb))
                  res = res + "C";

               last_digit = false;

         } else if (IsDigit(symb))
         {
               if (!last_digit)
                  res = res + "d";

               last_digit = true;

         } else
         {
               if (IsLatin(symb))
                  res = res + "o";
               else if (IsCyrillic(symb))
                  res = res + "O";

               last_digit = false;

         }
      }
   }

   return res;
}
