#pragma once

#include <util/generic/string.h>

#define SYMB_VOWEL                 0x00000001
#define SYMB_CONST                 0x00000002
#define SYMB_LAT                   0x00000004
#define SYMB_CYRILLIC              0x00000008
#define SYMB_DIGIT                 0x00000010

#define SET_SYMB_VOWEL(flag)       { (flag) |= SYMB_VOWEL;        }
#define SET_SYMB_CONST(flag)       { (flag) |= SYMB_CONST;        }
#define SET_SYMB_LAT(flag)         { (flag) |= SYMB_LAT;          }
#define SET_SYMB_CYRILLIC(flag)    { (flag) |= SYMB_CYRILLIC;     }
#define SET_SYMB_DIGIT(flag)       { (flag) |= SYMB_DIGIT;        }

#define IS_SYMB_VOWEL(flag)        ( (flag) & SYMB_VOWEL          )
#define IS_SYMB_CONST(flag)        ( (flag) & SYMB_CONST          )
#define IS_SYMB_LAT(flag)          ( (flag) & SYMB_LAT            )
#define IS_SYMB_CYRILLIC(flag)     ( (flag) & SYMB_CYRILLIC       )
#define IS_SYMB_DIGIT(flag)        ( (flag) & SYMB_DIGIT          )

class TSymbolSKClass
{
private:
         char symb_array[256];
public:
         TSymbolSKClass();
         ~TSymbolSKClass();

         bool IsVowel(char symb);
         bool IsConstanant(char symb);
         bool IsLatin(char symb);
         bool IsCyrillic(char symb);
         bool IsDigit(char symb);


         TString Normaliz01(const TString &text);
};
