#include <mail/so/spamstop/tools/so-common/color_scheme.h>
#include "ttraccert_fd_stat.h"

//*******************************************************************************************************************************************
//                                                       TTraccertStat
//*******************************************************************************************************************************************

namespace trcstat_fd
{

//*******************************************************************************************************************************************
//                                        TTraccertResultStat
//*******************************************************************************************************************************************

TTraccertResultStat::TTraccertResultStat()
{

}

TTraccertResultStat::~TTraccertResultStat()
{

}

void TTraccertResultStat::AddStatusWoML(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_wo_ml.m_today.m_ham = IncMax32(m_res_wo_ml.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_wo_ml.m_today.m_spam = IncMax32(m_res_wo_ml.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_wo_ml.m_today.m_malic = IncMax32(m_res_wo_ml.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_wo_ml.m_today.m_empty = IncMax32(m_res_wo_ml.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusWithML(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_with_ml.m_today.m_ham = IncMax32(m_res_with_ml.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_with_ml.m_today.m_spam = IncMax32(m_res_with_ml.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_with_ml.m_today.m_malic = IncMax32(m_res_with_ml.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_with_ml.m_today.m_empty = IncMax32(m_res_with_ml.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::Midnight()
{
   m_Mutex.Acquire();

   m_res_wo_ml.Midnight();
   m_res_with_ml.Midnight();
   m_res_final.Midnight();

   m_res_hamtospambyml.Midnight();
   m_res_malictospambyml.Midnight();
   m_res_spamtohambyml.Midnight();
   m_res_malictohambyml.Midnight();

   m_res_hamtospam_final.Midnight();
   m_res_hamtomalic_final.Midnight();
   m_res_spamtoham_final.Midnight();
   m_res_spamtomalic_final.Midnight();
   m_res_malictoham_final.Midnight();
   m_res_malictospam_final.Midnight();

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusFinal(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_final.m_today.m_ham = IncMax32(m_res_final.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_final.m_today.m_spam = IncMax32(m_res_final.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_final.m_today.m_malic = IncMax32(m_res_final.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_final.m_today.m_empty = IncMax32(m_res_final.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusHamToSpamByML(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_hamtospambyml.m_today.m_ham = IncMax32(m_res_hamtospambyml.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_hamtospambyml.m_today.m_spam = IncMax32(m_res_hamtospambyml.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_hamtospambyml.m_today.m_malic = IncMax32(m_res_hamtospambyml.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_hamtospambyml.m_today.m_empty = IncMax32(m_res_hamtospambyml.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusMalicToSpamByML(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_malictospambyml.m_today.m_ham = IncMax32(m_res_malictospambyml.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_malictospambyml.m_today.m_spam = IncMax32(m_res_malictospambyml.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_malictospambyml.m_today.m_malic = IncMax32(m_res_malictospambyml.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_malictospambyml.m_today.m_empty = IncMax32(m_res_malictospambyml.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusSpamToHamByML(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_spamtohambyml.m_today.m_ham = IncMax32(m_res_spamtohambyml.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_spamtohambyml.m_today.m_spam = IncMax32(m_res_spamtohambyml.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_spamtohambyml.m_today.m_malic = IncMax32(m_res_spamtohambyml.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_spamtohambyml.m_today.m_empty = IncMax32(m_res_spamtohambyml.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusMalicToHamByML(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_malictohambyml.m_today.m_ham = IncMax32(m_res_malictohambyml.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_malictohambyml.m_today.m_spam = IncMax32(m_res_malictohambyml.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_malictohambyml.m_today.m_malic = IncMax32(m_res_malictohambyml.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_malictohambyml.m_today.m_empty = IncMax32(m_res_malictohambyml.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusHamToSpamFinal(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_hamtospam_final.m_today.m_ham = IncMax32(m_res_hamtospam_final.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_hamtospam_final.m_today.m_spam = IncMax32(m_res_hamtospam_final.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_hamtospam_final.m_today.m_malic = IncMax32(m_res_hamtospam_final.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_hamtospam_final.m_today.m_empty = IncMax32(m_res_hamtospam_final.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusHamToMalicFinal(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_hamtomalic_final.m_today.m_ham = IncMax32(m_res_hamtomalic_final.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_hamtomalic_final.m_today.m_spam = IncMax32(m_res_hamtomalic_final.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_hamtomalic_final.m_today.m_malic = IncMax32(m_res_hamtomalic_final.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_hamtomalic_final.m_today.m_empty = IncMax32(m_res_hamtomalic_final.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusSpamToHamFinal(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_spamtoham_final.m_today.m_ham = IncMax32(m_res_spamtoham_final.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_spamtoham_final.m_today.m_spam = IncMax32(m_res_spamtoham_final.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_spamtoham_final.m_today.m_malic = IncMax32(m_res_spamtoham_final.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_spamtoham_final.m_today.m_empty = IncMax32(m_res_spamtoham_final.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusSpamToMalicFinal(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_spamtomalic_final.m_today.m_ham = IncMax32(m_res_spamtomalic_final.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_spamtomalic_final.m_today.m_spam = IncMax32(m_res_spamtomalic_final.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_spamtomalic_final.m_today.m_malic = IncMax32(m_res_spamtomalic_final.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_spamtomalic_final.m_today.m_empty = IncMax32(m_res_spamtomalic_final.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusMalicToHamFinal(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_malictoham_final.m_today.m_ham = IncMax32(m_res_malictoham_final.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_malictoham_final.m_today.m_spam = IncMax32(m_res_malictoham_final.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_malictoham_final.m_today.m_malic = IncMax32(m_res_malictoham_final.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_malictoham_final.m_today.m_empty = IncMax32(m_res_malictoham_final.m_today.m_empty, 1);

   m_Mutex.Release();
}

void TTraccertResultStat::AddStatusMalicToSpamFinal(ui32 spam_weight)
{
   m_Mutex.Acquire();

   if (spam_weight == KPHAM)
      m_res_malictospam_final.m_today.m_ham = IncMax32(m_res_malictospam_final.m_today.m_ham, 1);
   else if (spam_weight == KPSPAM)
      m_res_malictospam_final.m_today.m_spam = IncMax32(m_res_malictospam_final.m_today.m_spam, 1);
   else if (spam_weight == KPMALIC)
      m_res_malictospam_final.m_today.m_malic = IncMax32(m_res_malictospam_final.m_today.m_malic, 1);
   else if (spam_weight == KPUNKNOWN)
      m_res_malictospam_final.m_today.m_empty = IncMax32(m_res_malictospam_final.m_today.m_empty, 1);

   m_Mutex.Release();
}

TString IntToStrokaDef(ui32 value)
{
   if (value == 0)
      return "-";
   else
      return IntToStroka(value);
}

TString TTraccertResultStat::GetWebStat()
{
   TString res = "";

   res += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(color_table_default) + ">\n";

   res += "<tr align='center' bgcolor=" + TString(color_table_shap) + ">";
   res += "<td width='20%'><b>&nbsp;</b></td>";
   res += "<td width='40%' colspan='5'><b>TODAY</b></td>";
   res += "<td width='40%' colspan='5'><b>YESTERDAY</b></td>";
   res += "</tr>";

   res += "<tr align='center' bgcolor=" + TString(color_table_shap) + ">";
   res += "<td width='20%'><b>&nbsp;</b></td>";
   res += "<td width='8%'><b>ALL</b></td>";
   res += "<td width='8%'><b>HAM</b></td>";
   res += "<td width='8%'><b>SPAM</b></td>";
   res += "<td width='8%'><b>MALIC</b></td>";
   res += "<td width='8%'><b>EMPTY</b></td>";
   res += "<td width='8%'><b>ALL</b></td>";
   res += "<td width='8%'><b>HAM</b></td>";
   res += "<td width='8%'><b>SPAM</b></td>";
   res += "<td width='8%'><b>MALIC</b></td>";
   res += "<td width='8%'><b>EMPTY</b></td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>woML</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_wo_ml.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>withML</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_with_ml.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>Final</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_final.m_yesterday.m_empty) + "</td>";
   res += "</tr>";






   res += "<tr align='right'>";
   res += "<td align='left'>Diff: woML=ham & withML=spam</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospambyml.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>Diff: woML=malic & withML=spam</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospambyml.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>Diff: woML=spam & withML=ham</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtohambyml.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>Diff: woML=malic & withML=ham</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictohambyml.m_yesterday.m_empty) + "</td>";
   res += "</tr>";





   res += "<tr align='right'>";
   res += "<td align='left'>Change ham to spam (FINAL)</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtospam_final.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>Change ham to malic (FINAL)</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_hamtomalic_final.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>Change spam to ham (FINAL)</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtoham_final.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>Change spam to malic (FINAL)</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_spamtomalic_final.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>Change malic to ham (FINAL)</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictoham_final.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "<tr align='right'>";
   res += "<td align='left'>Change malic to spam (FINAL)</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_today.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_today.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_today.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_today.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_today.m_empty) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_yesterday.All()) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_yesterday.m_ham) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_yesterday.m_spam) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_yesterday.m_malic) + "</td>";
   res += "<td>" + IntToStrokaDef(m_res_malictospam_final.m_yesterday.m_empty) + "</td>";
   res += "</tr>";

   res += "</table>";

   return res;
}

//*******************************************************************************************************************************************

}

//*******************************************************************************************************************************************
