#pragma once

#include <sys/stat.h>
#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "util/system/thread.h"
#include "util/thread/factory.h"
#include <library/cpp/cgiparam/cgiparam.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include "tstoragetypes.h"
#include "kqueuestat.h"
#include "tfrodotypes.h"
#include <list>

//**************************************************************************************************************************
//                                           TUpdateQueueRqstErr
//**************************************************************************************************************************

struct TUpdateQueueRqstErr {
    ui32 m_tick{};

    TUpdateQueueRqstErr() {
        Clear();
    }

    void Clear() {
        m_tick = 0;
    }
};

//**************************************************************************************************************************
//                                           TUpdateQueueRecord
//**************************************************************************************************************************

enum TUpdateQueueRecordType { TYPE_1,
                              TYPE_2 };

struct TUpdateQueueRecord {
    bool m_is_incrs = true;
    TUpdateQueueRecordType m_rectype = TYPE_1;
    frodo_st::TStorageData m_longdata;
    TString m_Numbrequest;
    kday_t m_day = kday_t(static_cast<unsigned long>(0));
    TKTypeSpam m_spamt = KHAM0;
    i32 m_ham{};
    i32 m_spam85{};
    i32 m_spam100{};

    TUpdateQueueRecord() = default;

    TUpdateQueueRecord(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, TKTypeSpam spamt) {
        m_is_incrs = is_incrs;
        m_rectype = TYPE_1;
        m_longdata = longdata;
        m_Numbrequest = Numbrequest;
        m_day = day;
        m_spamt = spamt;
    }

    TUpdateQueueRecord(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, i32 ham, i32 spam85, i32 spam100) {
        m_is_incrs = is_incrs;
        m_rectype = TYPE_2;
        m_longdata = longdata;
        m_Numbrequest = Numbrequest;
        m_day = day;
        m_ham = ham;
        m_spam85 = spam85;
        m_spam100 = spam100;
    }
};

typedef std::list<TUpdateQueueRecord> TUpdateQueueRecordList;
typedef TUpdateQueueRecordList::iterator TUpdateQueueRecordListIt;

//**************************************************************************************************************************
//                                           TUpdateQueueMain
//**************************************************************************************************************************

class TUpdateQueue {
private:
    void* stornosqlobj{};
    ui32 m_thread_count{};
    ui32 m_size_fast{};
    TMutex m_Mutex;

    TUpdateQueueRecordList fast_list;
    qustat::TDriverRqstPoolStat fast_current_stat;
    qustat::TDriverRqstPoolStat fast_today_stat;
    qustat::TDriverRqstPoolStat fast_yesterday_stat;

public:
    TUpdateQueue();
    ~TUpdateQueue();

    bool Init(void* stornosqlobjA, ui32 thread_count, ui32 size_fast);
    void Midnight();

    void ActionFunction(int threadnumber, bool& needstop);
    bool AddRecord(const TUpdateQueueRecord& value);

    TString PrintWebStatistik();
    TString GetMonStatistik();

    qustat::TDriverRqstPoolStatFour GetConsoleStat();

    TString GetProperties();
};

//***************************************************************************************************************************
//                                                 TUpdateQueueMain
//***************************************************************************************************************************

class TUpdateQueueMain {
public:
    static const ui32 MAX_THREAD_WORK = 64;
    static const ui32 DEFAULT_THREAD_WORK = 32;
    static const ui32 DEFAULT_QUEUE_SIZE = 10000;

private:
    TUpdateQueue* dr_obj;

    TThread* m_QueueThread[MAX_THREAD_WORK];
    TMutex m_QueueMutex;
    bool m_StopQueueThread;
    bool run_scan_thread;
    ui32 m_thread_count;

    int use_threadcount;
    void StartQueueThread();
    bool QueueThreadStopped();

public:
    ui32 GetThreadCount() {
        return m_thread_count;
    }
    void StopQueueThread();
    int IncrementNumberThread();
    void DecrementNumberThread();
    bool QueueThreadShouldStop() {
        return m_StopQueueThread;
    }
    void ActionFunction(int threadnumber);
    bool InitBase(ui32 thread_count);

public:
    TUpdateQueueMain();
    ~TUpdateQueueMain();

    bool Init(void* stornosqlobjA, TKConfig* configobjA);
    void Midnight();

    bool AddRecord(const TUpdateQueueRecord& value);

    TString PrintWebStatistik();
    TString GetMonStatistik();
    qustat::TDriverRqstPoolStatFour GetConsoleStat();

    TString GetProperties();
};

//***************************************************************************************************************************
