#pragma once

#include <library/cpp/config/config.h>
#include <library/cpp/json/json_value.h>
#include <mail/so/libs/scheduler/scheduler.h>
#include <mail/so/spamstop/tools/general_shingler/data/field.h>

namespace NGeneralShingler {

    enum class TCacheType{
        Step,
        LRU,
        LAT
    };

    class ICache{
    public:
        using TKey = size_t;
        using TValue = NJson::TJsonValue::TArray;
        virtual bool Add(TKey key, TValue && value) = 0;
        virtual bool Get(TKey key, TValue & val) const = 0;
        virtual size_t Size() const = 0;
        virtual ~ICache() = default;
    };

    TAtomicSharedPtr<ICache> CreateCache(const NConfig::TConfig & config, TSimpleScheduler* scheduler, const TString & scheduleTag);

    struct TCacheContext{
        TAtomicSharedPtr <ICache> cache;
        size_t CreateKey(const NJson::TJsonValue & value, const TFieldSet & set) const;

        explicit TCacheContext(const NConfig::TConfig & config, TAtomicSharedPtr<ICache> cache);

        ~TCacheContext();
    private:
        TVector<TString> fieldNames;
    };
}   //  namespace NGeneralShingler

