
#include <mail/so/spamstop/tools/so-common/AnyValue_v2.h>
#include <util/generic/bt_exception.h>
#include <library/cpp/string_utils/quote/quote.h>
#include "cast.h"

namespace NGeneralShingler {
    class TJsonVisitorBase {
    public:
        TJsonVisitorBase(NJson::TJsonValue& jsonValue) : jsonValue(jsonValue) { }

        void operator()(TNoType) { }

    protected:
        NJson::TJsonValue& jsonValue;
    };

    struct TJsonVisitorScalar : public TJsonVisitorBase {
        TJsonVisitorScalar(NJson::TJsonValue& jsonValue) : TJsonVisitorBase(jsonValue) { }
        using TJsonVisitorBase::operator();

        void operator()(const NAnyValue::TOid& oid) {
            (*this)(oid.get());
        }

        template<typename T>
        void operator()(const T& value) {
            this->jsonValue = value;
        }
    };

    void AnyvalueToJson(const NAnyValue::TScalar &anyValue, NJson::TJsonValue &jsonValue) {
        TJsonVisitorScalar visitor(jsonValue);
        anyValue.Visit(visitor);
    }

    template<typename T>
    void AnyvalueToJsonMap(const T &anyValue, NJson::TJsonValue &jsonValue) {
        jsonValue.SetType(NJson::JSON_MAP);

        for (const auto & p : anyValue) {
            AnyvalueToJson(p.second, jsonValue[p.first]);
        }
    }

    void AnyvalueToJson(const NAnyValue::TMap &anyValue, NJson::TJsonValue &jsonValue) {
        AnyvalueToJsonMap(anyValue, jsonValue);
    }

    void AnyvalueToJson(const NAnyValue::TScalarMap &anyValue, NJson::TJsonValue &jsonValue) {
        AnyvalueToJsonMap(anyValue, jsonValue);
    }

    void AnyvalueToJson(const NAnyValue::TArray &anyValue, NJson::TJsonValue &jsonValue) {
        jsonValue.SetType(NJson::JSON_ARRAY);

        for(const auto & p : anyValue) {
            AnyvalueToJson(p, jsonValue.GetArraySafe().emplace_back());
        }
    }

    struct TJsonVisitorAnyValue : public TJsonVisitorBase {
        TJsonVisitorAnyValue(NJson::TJsonValue& jsonValue) : TJsonVisitorBase(jsonValue) { }
        using TJsonVisitorBase::operator();

        template<typename T>
        void operator()(const T& value) {
            AnyvalueToJson(value, this->jsonValue);
        }
    };

    void AnyvalueToJson(const NAnyValue::TAnyValue &anyValue, NJson::TJsonValue &jsonValue) {
        TJsonVisitorAnyValue visitor(jsonValue);
        anyValue.Visit(visitor);
    }

}   //  namespace NGeneralShingler{

