#pragma once

#include <util/generic/ptr.h>
#include <util/generic/hash.h>
#include <util/generic/string.h>

class TStorageBase;
class TSimpleScheduler;
namespace NConfig{
    class TConfig;
}

namespace NGeneralShingler {
    class TTimeSet;
    class TSchemeBase;

    enum class TCleanupType {
        Period,
        Change
    };

    void SetCleanupSchedules(TSimpleScheduler& scheduler,
        const NConfig::TConfig& config,
        const TAtomicSharedPtr<TStorageBase>& db,
        const TString& collection,
        const THashMap<TString, TAtomicSharedPtr<TSchemeBase>>& schemesByName,
        const THashMap<TString, TTimeSet>& timeSetsByName
    );
}
