#pragma once

#include <util/generic/hash_set.h>
#include <mail/so/spamstop/tools/so-common/AnyValue_v2.h>
#include "message.h"

namespace NConfig{
    class TConfig;
    struct TArray;
}

namespace NJson{
    class TJsonValue;
}

namespace NGeneralShingler {

    enum class TSupportedType : ui8 {
        Bool,
        Ui16,
        Ui32,
        Ui64,
        I64,
        String,
        Double,
    };

    class IField {
    public:
        void JsonToAnyvalue(const NJson::TJsonValue &messageFields, NAnyValue::TScalarMap &data, const TString &key) const {
            if (messageFields.Has(key))
                JsonToAnyvalue(messageFields[key], data[key]);
        }
        void Incr(const NJson::TJsonValue &messageFields, NAnyValue::TScalarMap &data, const TString &key) const {
            if (messageFields.Has(key))
                Incr(messageFields[key], data[key]);
        }
        void Or(const NJson::TJsonValue &messageFields, NAnyValue::TScalarMap &data, const TString &key) const {
            if (messageFields.Has(key))
                Or(messageFields[key], data[key]);
        }

        virtual void JsonToAnyvalue(const NJson::TJsonValue &message, NAnyValue::TScalar &anyValue) const = 0;
        virtual void Incr(const NJson::TJsonValue &message, NAnyValue::TScalar &anyValue) const = 0;
        virtual void Or(const NJson::TJsonValue &message, NAnyValue::TScalar &anyValue) const = 0;
        virtual size_t Hash(const NJson::TJsonValue & js) const = 0;

        virtual ~IField() = default;
    };
    using IFieldPtr = TAtomicSharedPtr<IField>;

    THolder<IField> FieldFabric(const NConfig::TConfig &config);

    class TFieldSet {
    public:
        using TFields = THashMap<TString, IFieldPtr>;
        using TNamedField = const TFields::value_type;

        TVector<TNamedField> LinkFields(const NConfig::TArray &array) const;
        TVector<TNamedField> LinkFields(const NConfig::TConfig & config) const;

        IFieldPtr GetField(const TString & name) const;
        IFieldPtr GetFieldSafe(const TString & name) const;
        TFieldSet() = default;
        explicit TFieldSet(const NConfig::TConfig &config);
    private:
        THashMap<TString, IFieldPtr> fields;
    };

    class TFieldSets {
    public:
        const TFieldSet & GetSetSafe(const NConfig::TConfig &config) const;
        explicit TFieldSets(const NConfig::TConfig &config);
    private:
        THashMap<TString, TFieldSet> sets;
    };
}

