#pragma once

#include <util/generic/hash.h>
#include <util/generic/yexception.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>

namespace NHelper {
    template<typename T, typename Key>
    const T& GetSafe(const THashMap<Key, T>& data, const Key& key) {
        auto it = data.find(key);
        if (it == data.end())
            ythrow TWithBackTrace<yexception>() << "cannot find " << key;

        return it->second;
    }

    template<typename T, typename Key>
    const T& GetSafe(const THashMap<Key, T>& data, const Key& key, const T& def) {
        auto it = data.find(key);
        return (it == data.end()) ? def : it->second;
    }
}

