#pragma once

#include <mail/so/spamstop/tools/so-common/AnyValue_v2.h>
#include <mail/so/spamstop/tools/general_shingler/data/field.h>
#include <mail/so/spamstop/tools/general_shingler/data/cache.h>

namespace NJson{
    class TJsonValue;
}

struct TQueryData;
namespace NGeneralShingler {
    enum class TKeyType {
        Simple,
        Greater,
        Time,
        History,
        Yesterday,
        Older,
        In
    };

    class TKeyScheme{
    public:
        size_t Hash(const NJson::TJsonValue & messageFields) const;
        virtual void Apply(TQueryData & query, const NJson::TJsonValue & messageFields) const = 0;
        virtual ~TKeyScheme() = default;

        explicit TKeyScheme(TVector<TFieldSet::TNamedField> fields);

    protected:
        TVector<TFieldSet::TNamedField> fields;
    };

    class TTimeSet;
    THolder<TKeyScheme> KeyFactory(const TString& typeName, const NConfig::TConfig & config, const TFieldSet & set, const THashMap<TString, TTimeSet> & timeSetsByName);
}

