#pragma once

#include <utility>
#include <util/generic/maybe.h>
#include <library/cpp/json/json_value.h>
#include <util/generic/vector.h>
#include <util/generic/deque.h>

class IInputStream;

namespace NGeneralShingler{

    enum class TMessageType{
        Get,
        Update,
        SyncUpdate
    };

    using TShard = TMaybe<size_t>;

    struct TShardedFields{
        TShardedFields() = default;

        bool operator==(const TShardedFields &rhs) const {
            return fields == rhs.fields &&
                   shard == rhs.shard;
        }

        explicit TShardedFields(size_t s) : shard(s) {}

        explicit TShardedFields(TMaybe<size_t> s) : shard(std::move(s)) {}

        TShardedFields(NJson::TJsonValue::TArray fields, size_t shard) : fields(std::move(fields)), shard(shard) {}

        explicit TShardedFields(NJson::TJsonValue::TArray fields) : fields(std::move(fields)) {}

        NJson::TJsonValue::TArray fields;
        TShard shard;
    };

    class TMessage{
    public:
        const TVector<TString> & GetSchemes() const { return schemes; }
        TMessageType GetType() const { return type; }
        TDeque<TShardedFields> & GetShardedFields() { return shardedFields; }
        const TDeque<TShardedFields> & GetShardedFields() const { return shardedFields; }


        TMessage(TVector<TString> schemes, TMessageType type, TDeque<TShardedFields> shardedFields = {})
                : schemes(std::move(schemes)),
                  type(type),
                  shardedFields(std::move(shardedFields)) {}


        TMessage(TVector<TString> schemes, TMessageType type, NJson::TJsonValue::TArray fields)
                : schemes(std::move(schemes)),
                  type(type),
                  shardedFields(TDeque<TShardedFields>{TShardedFields(std::move(fields))}) {}


        TMessage(TString scheme, TMessageType type) : TMessage(TVector<TString>{std::move(scheme)}, type) {}

        TMessage(TString scheme, TMessageType type, NJson::TJsonValue::TArray fields)
                : TMessage(TVector<TString>{std::move(scheme)}, type, std::move(fields)) {}

        TMessage(TString scheme, TMessageType type, TDeque<TShardedFields> shardedFields)
                : TMessage(TVector<TString>{std::move(scheme)}, type, std::move(shardedFields)) {}

    private:
        TVector<TString> schemes;
        TMessageType type;
        TDeque<TShardedFields> shardedFields;
    };


    using TMessages = TVector<TMessage>;
}

Y_DECLARE_OUT_SPEC(inline, NGeneralShingler::TShardedFields, s, value) {
    s << value.shard << ": ";
    for(const auto & v : value.fields)
        s << v << ',';
}
