#pragma once

#include <mail/so/spamstop/tools/general_shingler/data/message.h>

namespace NConfig{
    class TConfig;
}

namespace NGeneralShingler {

    class TSharder{
    public:
        static inline ui64 CalcShard(ui64 v) {
            return v % ((1<<16)-2);
        }

        struct TSharded {
            void AddSharded(size_t shard, NJson::TJsonValue::TArray && values);

            THashMap<size_t, TShardedFields> groupedByShard;
            TShardedFields withoutShard;
        };

        TSharded Shardify(NJson::TJsonValue::TArray && messageFields) const;

        explicit TSharder(const NConfig::TConfig & config);

    private:
        TString shardBy{};
    };

}
