
#include <library/cpp/config/config.h>
#include <util/generic/yexception.h>
#include <util/generic/bt_exception.h>
#include <mail/so/libs/talkative_config/config.h>

#include "time_set.h"


namespace NGeneralShingler {
    ui64 TTimeSet::GetPeriod(TInstant t) const {
        if(resolution == TDuration::Zero())
            ythrow TWithBackTrace<yexception>() << "zero resolution";

        return (t - offset).Seconds() / resolution.Seconds();
    }

    ui64 TTimeSet::GetCurrentPeriod() const {
        return GetPeriod(Now());
    }

    TInstant TTimeSet::ToInstant(ui64 period) const {
        return TInstant::Seconds(period * resolution.Seconds() + offset.Seconds());
    }

    const TDuration & TTimeSet::GetResolution() const {
        return resolution;
    }

    const TInstant & TTimeSet::GetOffset() const {
        return offset;
    }

    TTimeSet::TTimeSet() = default;
    TTimeSet::TTimeSet(const NConfig::TConfig & config) {
        if(config.Has("resolution"))
            resolution = NTalkativeConfig::As<TDuration>(config, "resolution");
        if(config.Has("offset"))
            offset = NTalkativeConfig::As<TInstant>(config, "offset");
    }
}



