#pragma once

#include <util/datetime/base.h>

namespace NConfig {
    class TConfig;
}

namespace NGeneralShingler {

    class TTimeSet{
    public:
        ui64 GetPeriod(TInstant t) const;

        ui64 GetCurrentPeriod() const;

        TInstant ToInstant(ui64 period) const;

        const TDuration& GetResolution() const;

        const TInstant & GetOffset() const;

        TTimeSet();
        explicit TTimeSet(const NConfig::TConfig & config);
    private:
        TDuration resolution = TDuration::Seconds(1);
        TInstant offset{};
    };
}



