#include <library/cpp/testing/unittest/registar.h>
#include "cast.h"

using namespace NGeneralShingler;

Y_UNIT_TEST_SUITE(Cast) {
    Y_UNIT_TEST(Main) {
        NAnyValue::TArray integers;
        NAnyValue::TMap map;

        integers.emplace_back(ui16(0));
        integers.emplace_back(ui32(1));
        integers.emplace_back(ui64(2));
        integers.emplace_back( i64(3));

        map["integers"] = NAnyValue::TAnyValue(integers);
        map["double"] = 3.14;
        map["bool"] = false;
        map["string"] = TString("stroka");
        map["oid"] = NAnyValue::TOid("0x1234");
        map["empty"];

        NAnyValue::TAnyValue value(map);
        NJson::TJsonValue json;

        NGeneralShingler::AnyvalueToJson(value, json);

        UNIT_ASSERT_EQUAL(json.IsMap(), true);
        const auto integersJson = json["integers"].GetArraySafe();
        UNIT_ASSERT_EQUAL(integersJson[0].IsUInteger(), true);
        UNIT_ASSERT_EQUAL(integersJson[0].GetUInteger(), 0);

        UNIT_ASSERT_EQUAL(integersJson[1].IsUInteger(), true);
        UNIT_ASSERT_EQUAL(integersJson[1].GetUInteger(), 1);

        UNIT_ASSERT_EQUAL(integersJson[2].IsUInteger(), true);
        UNIT_ASSERT_EQUAL(integersJson[2].GetUInteger(), 2);

        UNIT_ASSERT_EQUAL(integersJson[3].IsInteger(), true);
        UNIT_ASSERT_EQUAL(integersJson[3].GetInteger(), 3);

        UNIT_ASSERT_EQUAL(json["double"].IsDouble(), true);
        UNIT_ASSERT_EQUAL(json["double"].GetDouble(), 3.14);

        UNIT_ASSERT_EQUAL(json["bool"].IsBoolean(), true);
        UNIT_ASSERT_EQUAL(json["bool"].GetBoolean(), false);

        UNIT_ASSERT_EQUAL(json["string"].IsString(), true);
        UNIT_ASSERT_EQUAL(json["string"].GetString(), "stroka");

        UNIT_ASSERT_EQUAL(json["oid"].IsString(), true);
        UNIT_ASSERT_EQUAL(json["oid"].GetString(), "0x1234");

        UNIT_ASSERT_EQUAL(json["empty"].IsDefined(), false);
    }
}

