#include <util/thread/pool.h>
#include <library/cpp/config/config.h>
#include <library/cpp/testing/unittest/registar.h>
#include <mail/so/libs/scheduler/scheduler.h>
#include <mail/so/spamstop/tools/so-common/StorageBase.h>
#include <mail/so/spamstop/tools/general_shingler/shingler/schemes/base.h>
#include "time_set.h"
#include "cleanup.h"

using namespace NGeneralShingler;

struct TSchemeMock : public TSchemeBase {
    THolder<IFuture> Find(TInstant, const TShardedFields&) override {
        Y_VERIFY(false);
        return nullptr;
    }

    void Update(const TDeque<TShardedFields>&) override {
        Y_VERIFY(false);
    }

    size_t Remove(TShardedFields) override {
        return 42;
    }
};

struct TStorageMock : public TStorageBase {
    void SetReadTimeout(const TDuration&) override {};
    TDuration GetReadTimeout() const override {
        return {};
    };
    void SetWriteTimeout(const TDuration&) override {};
    TDuration GetWriteTimeout() const override {
        return {};
    }

    size_t Count(const TString&, const TFindAction&) override {
        Y_VERIFY(false);
        return 0;
    }

    size_t Remove(const TString&, const TFindAction&) override {
        Y_VERIFY(false);
        return 0;
    }

    size_t Update(const TString& collectionName, const TUpdateAction& actions) override {
        UNIT_ASSERT_EQUAL(collectionName, "statistic");
        updates.push_back(actions);
        return 1;
    }

    void UpdateSeries(const TString&, const TActionSeries&, bool) override {
        Y_VERIFY(false);
    }

    void UpdateBulk(const TString&, const TUpdateAction&) override {
        Y_VERIFY(false);
    }

    void Find(const TString&, const TFindAction&, TFindResults&) override {
        Y_VERIFY(false);
    }

    void FindOne(const TString&, const TFindAction&, NAnyValue::TScalarMap&) override {
        Y_VERIFY(false);
    }

    THolder<IFuture> FindNonblock(TInstant, const TString&, const TFindAction&) override {
        Y_VERIFY(false);
        return nullptr;
    }

    void Connect(const TString&) override {}
    void Connect(const NConfig::TConfig&) override {}

    TVector<TUpdateAction> updates;
};

Y_UNIT_TEST_SUITE(CleanUp) {
    Y_UNIT_TEST(Main) {
        auto db = MakeAtomicShared<TStorageMock>();
        THashMap<TString, TAtomicSharedPtr<TSchemeBase>> schemesByName;
        schemesByName["period"] = MakeAtomicShared<TSchemeMock>();
        schemesByName["time"] = MakeAtomicShared<TSchemeMock>();

        TStringStream time(R"({"resolution": "1s"})");
        THashMap<TString, TTimeSet> timeSetsByName;
        timeSetsByName["test"] = TTimeSet(NConfig::TConfig::FromJson(time));

        TStringStream json(R"in(
            [{
                "schedule": "PeriodChange",
                "time_set": "test",
                "scheme": "period"
            },
            {
                "schedule": "2s",
                "scheme": ["time"],
                "fields": {
                    "date": 183
                }
            }]
        )in");

        {
            auto threadPool = MakeAtomicShared<TAdaptiveThreadPool>();
            threadPool->Start(0, 0);

            TSimpleScheduler scheduler(*threadPool);
            NGeneralShingler::SetCleanupSchedules(scheduler, NConfig::TConfig::FromJson(json), db, "statistic", schemesByName, timeSetsByName);
            sleep(4);
        }

        UNIT_ASSERT_EQUAL(db->updates.size() > 6, true);
    }
}

