#include <util/thread/pool.h>
#include <library/cpp/testing/unittest/registar.h>
#include <mail/so/spamstop/tools/so-common/StorageBase.h>
#include "keys.h"
#include "time_set.h"

using namespace NGeneralShingler;

static TTimeSet GetTimeSet() {
    TStringStream ts = TString(R"({"resolution":"1h"})");
    return TTimeSet(NConfig::TConfig::FromJson(ts));
}

static const auto timeSet = GetTimeSet();

Y_UNIT_TEST_SUITE(Keys) {
    template<TKeyType type, bool simple = true>
    TQueryData ApplyImpl() {
        NConfig::TConfig config;
        THashMap<TString, TTimeSet> timeSetsByName;
        timeSetsByName["hour"] = timeSet;

        TStringStream fs = TString(R"({"shingle":"Ui64"})");
        TFieldSet set(NConfig::TConfig::FromJson(fs));

        TStringStream ss = simple? TString(R"("shingle")"): TString(R"({"fields":"shingle", "time_set":"hour"})");
        auto key = KeyFactory(ToString(type), NConfig::TConfig::FromJson(ss), set, timeSetsByName);
        UNIT_ASSERT_UNEQUAL(key, nullptr);

        NJson::TJsonValue value;
        value["shingle"] = 42;
        UNIT_ASSERT_EQUAL(key->Hash(value), 2059745618571851555ull);

        TQueryData data;
        key->Apply(data, value);
        return data;
    }

    template<TKeyType type>
    TQueryData ApplyImplTime() {
        return ApplyImpl<type, false>();
    }

    Y_UNIT_TEST(Apply) {
        UNIT_ASSERT_EQUAL(ApplyImpl<TKeyType::Simple>().equals["shingle"].AsUi64(), 42);
        UNIT_ASSERT_EQUAL(ApplyImpl<TKeyType::Greater>().gt["shingle"].AsUi64(), 42);
        UNIT_ASSERT_EQUAL(ApplyImplTime<TKeyType::Time>().equals["shingle"].AsUi64(), timeSet.GetCurrentPeriod());
        UNIT_ASSERT_EQUAL(ApplyImplTime<TKeyType::History>().gt["shingle"].AsUi64(), timeSet.GetCurrentPeriod() - 43);
        UNIT_ASSERT_EQUAL(ApplyImplTime<TKeyType::Yesterday>().lt["shingle"].AsUi64(), timeSet.GetCurrentPeriod());
        UNIT_ASSERT_EQUAL(ApplyImplTime<TKeyType::Older>().lt["shingle"].AsUi64(), timeSet.GetCurrentPeriod() - 42);
    }
}

