#include <library/cpp/testing/unittest/registar.h>

#include "message.h"

using namespace NGeneralShingler;

Y_UNIT_TEST_SUITE(Message) {
    Y_UNIT_TEST(ShardedFields) {
        {
            TShardedFields fields;

            UNIT_ASSERT_EQUAL(fields.fields.empty(), true);
            UNIT_ASSERT_EQUAL(fields.shard, Nothing());
        }
        {
            TShardedFields fields(MakeMaybe(size_t(456)));

            UNIT_ASSERT_EQUAL(fields.fields.empty(), true);
            UNIT_ASSERT_EQUAL(fields.shard.Defined(), true);
            UNIT_ASSERT_EQUAL(*fields.shard, 456);
        }
        {
            TShardedFields fields(size_t(456));

            UNIT_ASSERT_EQUAL(fields.fields.empty(), true);
            UNIT_ASSERT_EQUAL(fields.shard.Defined(), true);
            UNIT_ASSERT_EQUAL(*fields.shard, 456);
        }
        {
            NJson::TJsonValue::TArray fields;
            fields.emplace_back()["asdasfg"] = 42;

            TShardedFields shardedFields(fields, 456);

            UNIT_ASSERT_EQUAL(shardedFields.fields, fields);
            UNIT_ASSERT_EQUAL(shardedFields.shard.Defined(), true);
            UNIT_ASSERT_EQUAL(*shardedFields.shard, 456);
        }
        {
            NJson::TJsonValue::TArray fields;
            fields.emplace_back()["asdasfg"] = 42;

            TShardedFields shardedFields(fields);

            UNIT_ASSERT_EQUAL(shardedFields.fields, fields);
            UNIT_ASSERT_EQUAL(shardedFields.shard, Nothing());
        }
    }
    Y_UNIT_TEST(Constructor) {
        {
            {
                TMessage msg("scheme_name", TMessageType::Get);

                UNIT_ASSERT_EQUAL(msg.GetSchemes(), TVector<TString>{"scheme_name"});
                UNIT_ASSERT_EQUAL(msg.GetType(), TMessageType::Get);
                UNIT_ASSERT_EQUAL(msg.GetShardedFields().size(), 0);
            }

            {
                NJson::TJsonValue::TArray fields;
                fields.emplace_back()["asdasfg"] = 42;

                TDeque<TShardedFields> shardedFields{TShardedFields(fields)};

                TVector<TString> schemes{"scheme_name", "scheme_name2"};
                const auto schemesCopy = schemes;
                TMessage msg(std::move(schemes), TMessageType::Update, fields);

                UNIT_ASSERT_EQUAL(msg.GetSchemes(), schemesCopy);
                UNIT_ASSERT_EQUAL(msg.GetType(), TMessageType::Update);
                UNIT_ASSERT_EQUAL(msg.GetShardedFields(), shardedFields);
            }

            {
                NJson::TJsonValue::TArray fields;
                fields.emplace_back()["asdasfg"] = 42;

                TDeque<TShardedFields> shardedFields{TShardedFields(fields)};
                TMessage msg("scheme_name", TMessageType::Update, fields);

                UNIT_ASSERT_EQUAL(msg.GetSchemes().size(), 1);
                UNIT_ASSERT_EQUAL(msg.GetSchemes().front(), "scheme_name");
                UNIT_ASSERT_EQUAL(msg.GetType(), TMessageType::Update);
                UNIT_ASSERT_EQUAL(msg.GetShardedFields(), shardedFields);
            }

            {
                NJson::TJsonValue::TArray fields;
                fields.emplace_back()["asdasfg"] = 42;

                TDeque<TShardedFields> shardedFields{TShardedFields(fields)};
                TMessage msg("scheme_name", TMessageType::Update, shardedFields);

                UNIT_ASSERT_EQUAL(msg.GetSchemes().size(), 1);
                UNIT_ASSERT_EQUAL(msg.GetSchemes().front(), "scheme_name");
                UNIT_ASSERT_EQUAL(msg.GetType(), TMessageType::Update);
                UNIT_ASSERT_EQUAL(msg.GetShardedFields(), shardedFields);
            }
        }
    }
}

