#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/config/config.h>
#include <library/cpp/json/json_reader.h>
#include "shard.h"

using namespace NGeneralShingler;

Y_UNIT_TEST_SUITE(Shard) {
    Y_UNIT_TEST(Main) {

        const auto config = [](){
            TString confContent = "{\n"
                                  "        \t\"field\": \"hash\"\n"
                                  "        }";
            return NConfig::TConfig::ReadJson(confContent);
        }();

        const auto sharder = NGeneralShingler::TSharder(config);

        auto valueToShard = [](){
            const TStringBuf data = R"([
                {
                    "hash": [4,2,5,8,65538],
                    "value": 2.5
                },
                {
                    "hash2": [4,2,5,8,65538],
                    "value": 2.5
                }
            ])";
            NJson::TJsonValue val;
            NJson::ReadJsonTree(data, &val, false);
            return std::move(val.GetArraySafe());
        }();

        auto shards = sharder.Shardify(std::move(valueToShard));

        {
            NJson::TJsonValue::TArray expected(2);
            {
                expected[0]["hash"].SetType(NJson::JSON_ARRAY).GetArraySafe().emplace_back(4);
                expected[0]["value"] = 2.5;
                expected[1]["hash"].SetType(NJson::JSON_ARRAY).GetArraySafe().emplace_back(65538);
                expected[1]["value"] = 2.5;
            }
            UNIT_ASSERT_EQUAL(shards.groupedByShard[4].fields, expected);

            UNIT_ASSERT(shards.groupedByShard.contains(4));
            UNIT_ASSERT_EQUAL(shards.groupedByShard[4].shard.GetRef(), 4);
        }
        {
            NJson::TJsonValue::TArray expected(1);
            {
                expected[0]["hash"].SetType(NJson::JSON_ARRAY).GetArraySafe().emplace_back(2);
                expected[0]["value"] = 2.5;
            }
            UNIT_ASSERT_EQUAL(shards.groupedByShard[2].fields, expected);

            UNIT_ASSERT(shards.groupedByShard.contains(2));
            UNIT_ASSERT_EQUAL(shards.groupedByShard[2].shard.GetRef(), 2);
        }
        {
            NJson::TJsonValue::TArray expected(1);
            {
                expected[0]["hash"].SetType(NJson::JSON_ARRAY).GetArraySafe().emplace_back(5);
                expected[0]["value"] = 2.5;
            }
            UNIT_ASSERT_EQUAL(shards.groupedByShard[5].fields, expected);

            UNIT_ASSERT(shards.groupedByShard.contains(5));
            UNIT_ASSERT_EQUAL(shards.groupedByShard[5].shard.GetRef(), 5);
        }
        {
            NJson::TJsonValue::TArray expected(1);
            {
                expected[0]["hash"].SetType(NJson::JSON_ARRAY).GetArraySafe().emplace_back(8);
                expected[0]["value"] = 2.5;
            }
            UNIT_ASSERT_EQUAL(shards.groupedByShard[8].fields, expected);

            UNIT_ASSERT(shards.groupedByShard.contains(8));
            UNIT_ASSERT_EQUAL(shards.groupedByShard[8].shard.GetRef(), 8);
        }
        {
            NJson::TJsonValue::TArray expected(1);
            {
                expected[0]["hash2"].SetType(NJson::JSON_ARRAY).GetArraySafe() = NJson::TJsonValue::TArray{4,2,5,8,65538};
                expected[0]["value"] = 2.5;
            }
            UNIT_ASSERT_EQUAL(shards.withoutShard.fields, expected);

            UNIT_ASSERT_EQUAL(shards.withoutShard.shard.Defined(), false);

        }
    }
}

