#include <library/cpp/testing/unittest/registar.h>

#include <library/cpp/config/config.h>
#include "time_set.h"

using namespace NGeneralShingler;

Y_UNIT_TEST_SUITE(TimeSet) {
    Y_UNIT_TEST(Construct) {
        {
            TTimeSet timeSet;

            UNIT_ASSERT_EQUAL(timeSet.GetCurrentPeriod(), timeSet.GetPeriod(Now()));
            UNIT_ASSERT_EQUAL(timeSet.GetResolution(), TDuration::Seconds(1));
            UNIT_ASSERT_EQUAL(timeSet.ToInstant(42), TInstant::Seconds(42));
            UNIT_ASSERT_EQUAL(42, timeSet.GetPeriod(TInstant::Seconds(42)));

        }
        {
            TStringStream src;
            {
                src <<
                "{"
                    "\"resolution\": \"100s\","
                    "\"offset\": \"2000-01-01\""
                "}";
            }
            TTimeSet timeSet(NConfig::TConfig::FromJson(src));

            UNIT_ASSERT_EQUAL(timeSet.GetCurrentPeriod(), (Now() - timeSet.GetOffset()).Seconds() / timeSet.GetResolution().Seconds());
            UNIT_ASSERT_EQUAL(timeSet.GetResolution(), TDuration::Seconds(100));
            UNIT_ASSERT_EQUAL(timeSet.ToInstant(42), timeSet.GetOffset() + timeSet.GetResolution() * 42);
            UNIT_ASSERT_EQUAL(1, timeSet.GetPeriod(timeSet.GetOffset() + TDuration::Seconds(162)));
        }
        {
            TStringStream src;
            {
                src <<
                    "{"
                    "\"resolution\": \"0s\""
                    "}";
            }
            TTimeSet timeSet(NConfig::TConfig::FromJson(src));

            UNIT_ASSERT_EXCEPTION(timeSet.GetPeriod(TInstant::Zero()), yexception);
        }


    }
}

