#pragma once

#include <utility>
#include <util/thread/pool.h>
#include <mail/so/spamstop/tools/general_shingler/data/message.h>
#include <mail/so/spamstop/tools/general_shingler/data/cache.h>

namespace NConfig{
    class TConfig;
}

class TStatsConsumer;
class TSimpleScheduler;
struct THandleContext;

namespace NGeneralShingler {
    struct TProcessor {
        virtual ~TProcessor() = default;
        virtual TVector<TMessage> ParseMessages(const TStringBuf &input) const = 0;
        virtual TVector<TMessage> ParseMessages(const THandleContext &handleContext) const = 0;

        virtual NJson::TJsonValue ProcessGetMessages(TMessages && messages) = 0;
        virtual void ProcessUpdateMessagesSync(TMessages && messages) = 0;
        virtual void ProcessUpdateMessages(TMessages && messages) = 0;
    };

    TAtomicSharedPtr<TProcessor> ProcessorFactory(const NConfig::TConfig &config,
        const TAtomicSharedPtr<IThreadPool>& pool,
        const TAtomicSharedPtr<TLog>& logger,
        THashMap<TString, TAtomicSharedPtr<ICache>>& caches,
        TSimpleScheduler& scheduler
    );
}

