#pragma once

#include <library/cpp/json/json_value.h>
#include <library/cpp/logger/log.h>

#include <mail/so/spamstop/tools/general_shingler/data/field.h>
#include <mail/so/spamstop/tools/general_shingler/data/time_set.h>
#include <mail/so/spamstop/tools/general_shingler/data/cache.h>
#include <library/cpp/coroutine/engine/impl.h>

#include "types.h"

struct TUpdateData;
class TStatsConsumer;
namespace NGeneralShingler {

    class IFuture{
    public:
        void Run(TCont* cont) noexcept try {
            DoRun(cont);
        } catch (...) {
            e = std::current_exception();
            cont->Cancel();
        }

        NJson::TJsonValue::TArray Extract() {
            if(e)
                std::rethrow_exception(e);
            return DoExtract();
        }

        virtual ~IFuture() = default;

        virtual inline void DoRun(TCont* cont) = 0;
        virtual inline NJson::TJsonValue::TArray DoExtract() = 0;
    private:
        std::exception_ptr e;
    };

    class TDummyFuture : public IFuture{
    public:
        void DoRun(TCont* /*cont*/) override {};
        NJson::TJsonValue::TArray DoExtract() override { return std::move(array); }

        explicit TDummyFuture(NJson::TJsonValue::TArray && array) : array(std::move(array)) {}
    protected:
        NJson::TJsonValue::TArray array;
    };

    class TSchemeBase {
    public:

        virtual THolder<IFuture> Find(TInstant deadline, const TShardedFields& sharded) = 0;
        virtual void Update(const TDeque<TShardedFields>& sharded) = 0;
        virtual size_t Remove(TShardedFields /*shardedFields*/) {
            ythrow TWithBackTrace<yexception>() << "remove unsupported";
        };

        void SetLogger(TAtomicSharedPtr<TLog> newLogger) { logger = std::move(newLogger); }

        virtual ~TSchemeBase() = default;

    protected:
        TAtomicSharedPtr<TLog> logger = MakeAtomicShared<TLog>();
    };

    template<typename TBase> struct TNonUpdatableScheme : public TBase {
        template<typename ... Types> explicit TNonUpdatableScheme(Types&& ... args) : TBase(std::forward<Types>(args)...) {}

        void Update(const TDeque<TShardedFields>&/*sharded*/) override {
            ythrow TWithBackTrace<yexception>() << "update unsupported";
        }
    };

    using TNonUpdatableSchemeBase = TNonUpdatableScheme<TSchemeBase>;

    class TUpdate{
    public:
        void Apply(TUpdateData & update, const NJson::TJsonValue & messageFields) const;
        TUpdate(const TString& typeName, const NConfig::TConfig &config, const TFieldSet & set, const THashMap<TString, TTimeSet>& timeSetsByName);

    private:
        TUpdateType type;
        TVector<TFieldSet::TNamedField> fields;
        TTimeSet timeSet;
    };

    class TStorage;
    TAtomicSharedPtr<TSchemeBase> SchemeFactory(const NConfig::TConfig &config,
        const THashMap<TString, TTimeSet>& timeSetsByName,
        const THashMap<TString, TAtomicSharedPtr<TCacheContext>>& cacheByName,
        const TFieldSets& sets, const TStorage & storage);
}

