#pragma once

#include "base.h"

namespace NGeneralShingler {
    struct TCacheContext;
    class TCachedSchemeBase : public TSchemeBase{
    public:

        THolder<IFuture> Find(TInstant deadline, const TShardedFields& sharded) override;
        void Update(const TDeque<TShardedFields>& sharded) override;
        virtual THolder<IFuture> InternalFind(TInstant /*deadline*/, const TShardedFields& /*sharded*/);

        TCachedSchemeBase(
                TFieldSet fields,
                TAtomicSharedPtr <TCacheContext> cacheContext) noexcept;

        ~TCachedSchemeBase() override;

    private:
        friend class TCacheFuture;
        bool FindInCache(size_t key, NJson::TJsonValue::TArray & jsResults) const;
        void PutInCache(NJson::TJsonValue::TArray values);

    protected:
        const TFieldSet fields;
        TAtomicSharedPtr <TCacheContext> cacheContext;
        const bool hasCache;
    };

    using TNonUpdatableCachedSchemeBase = TNonUpdatableScheme<TCachedSchemeBase>;
}
