#include <utility>
#include <util/generic/algorithm.h>
#include <mail/so/libs/curl/storage.h>
#include <mail/so/spamstop/tools/so-common/algorithm.h>
#include "curl_base.h"

namespace NGeneralShingler {
    TCurlScheme::TCurlScheme(TFieldSet fields,
                             TAtomicSharedPtr<TCacheContext> cacheContext,
                             TAtomicSharedPtr<NCurl::TStorage> storage,
                             TAtomicSharedPtr<NCurl::TPoolTraits> traits,
                             TFunction processor) noexcept
        : TCachedSchemeBase(std::move(fields), std::move(cacheContext))
        , storage(std::move(storage))
        , traits(std::move(traits))
        , processor(std::move(processor)) {

        Y_VERIFY(this->storage);
        Y_VERIFY(this->processor);
    }

    TCurlScheme::~TCurlScheme() = default;

    class TCurlFuture : public TDummyFuture {
    public:
        TCurlFuture(NJson::TJsonValue::TArray array, TVector<NCurl::TRequestContext>&& requests, TAtomicSharedPtr<NCurl::TStorage> storage, TAtomicSharedPtr<NCurl::TPoolTraits> traits, TCurlScheme::TFunction processor, const TInstant& deadline)
            : TDummyFuture(std::move(array))
            , requests(std::move(requests))
            , storage(std::move(storage))
            , traits(std::move(traits))
            , processor(std::move(processor))
            , deadline(deadline) {
        }

        void DoRun(TCont* cont) override {
            simultaneous_for_each_container_with_check(processor, storage->Process(std::move(requests), *traits, deadline, cont), array);
        }

        NJson::TJsonValue::TArray DoExtract() override {
            return TDummyFuture::DoExtract();
        }

    private:
        TVector<NCurl::TRequestContext> requests;
        TAtomicSharedPtr<NCurl::TStorage> storage;
        TAtomicSharedPtr<NCurl::TPoolTraits> traits;
        TCurlScheme::TFunction processor;
        const TInstant deadline;
    };

    THolder<IFuture> TCurlScheme::InternalFind(TInstant deadline, const TShardedFields& sharded) {
        TVector<NCurl::TRequestContext> requests(Reserve(sharded.fields.size()));

        CreateFindRequests(sharded.fields, requests, deadline);

        return MakeHolder<TCurlFuture>(sharded.fields, std::move(requests), storage, traits, processor, deadline);
    }

    void TCurlScheme::Update(const TDeque<TShardedFields>& sharded) {
        const size_t toBeUpdatedSize = Accumulate(sharded.cbegin(), sharded.cend(), 0ul, [](size_t s, const TShardedFields& f) {
            return s + f.fields.size();
        });
        TVector<NCurl::TRequestContext> requests(Reserve(toBeUpdatedSize));

        for (const auto& f : sharded) {
            CreateUpdateRequests(f.fields, requests);
        }

        storage->Process(std::move(requests), *traits, TInstant::Max());
    }

    void TCurlScheme::CreateFindRequests(const NJson::TJsonValue::TArray&, TVector<NCurl::TRequestContext>&, TInstant&) {
    }

    void TCurlScheme::CreateUpdateRequests(const NJson::TJsonValue::TArray&, TVector<NCurl::TRequestContext>&) {
    }
} // namespace NGeneralShingler
