#pragma once

#include <mail/so/libs/curl/storage.h>
#include <functional>
#include "cached.h"

namespace NCurl {
    struct TOptions;
    struct TRequestContext;
    struct TSimpleArtifacts;
    class TPoolTraits;
    class TStorage;
} // namespace NCurl

namespace NGeneralShingler {
    class TCurlScheme : public TCachedSchemeBase {
    public:
        using TFunction = std::function<void(const NCurl::TSimpleArtifacts&, NJson::TJsonValue&)>;
        TCurlScheme(TFieldSet fields,
                    TAtomicSharedPtr<TCacheContext> cacheContext,
                    TAtomicSharedPtr<NCurl::TStorage> storage,
                    TAtomicSharedPtr<NCurl::TPoolTraits> traits,
                    TFunction processor) noexcept;
        ~TCurlScheme() override;

        THolder<IFuture> InternalFind(TInstant deadline, const TShardedFields& sharded) override;
        void Update(const TDeque<TShardedFields>& sharded) override;

    protected:
        virtual void CreateFindRequests(const NJson::TJsonValue::TArray& messageFields, TVector<NCurl::TRequestContext>& requests, TInstant& deadline);
        virtual void CreateUpdateRequests(const NJson::TJsonValue::TArray& messageFields, TVector<NCurl::TRequestContext>& requests);

    private:
        TAtomicSharedPtr<NCurl::TStorage> storage;
        TAtomicSharedPtr<NCurl::TPoolTraits> traits;
        TFunction processor;
    };
} // namespace NGeneralShingler
