#pragma once

#include "../storages/db.h"
#include "cached.h"
#include <mail/so/spamstop/tools/general_shingler/data/keys.h>

namespace NGeneralShingler {
    class TDbScheme : public TCachedSchemeBase {
    public:
        THolder<IFuture> InternalFind(TInstant deadline, const TShardedFields& sharded) override;
        void Update(const TDeque<TShardedFields>& sharded) override;
        size_t Remove(TShardedFields sharded) override;

        static void SetOrder(TSchemeBase* scheme, TSchemeBase* order);

        explicit TDbScheme(
                TVector<TAtomicSharedPtr<TKeyScheme>> update_keys,
                TVector<TAtomicSharedPtr<TKeyScheme>> find_keys,
                TVector<TUpdate> updates,
                const TFieldSet & fields,
                const TAtomicSharedPtr <TCacheContext> &cacheContext,
                TTempDBContext dbContext,
                bool upsert,
                TAggregationType aggregationType)
                : TCachedSchemeBase(fields, cacheContext),
                  update_keys(std::move(update_keys)),
                  find_keys(std::move(find_keys)),
                  updates(std::move(updates)),
                  dbContext(std::move(dbContext)),
                  upsert(upsert),
                  aggregationType(aggregationType) {}
    private:
        void ProcessUpdate(const NJson::TJsonValue &messageFields, TActionSeries & series, TMaybe<size_t> shard) const;
        void ProcessFind(const NJson::TJsonValue &messageFields, TFindAction & findAction, TMaybe<size_t> shard) const;
    private:
        TVector<TAtomicSharedPtr<TKeyScheme>> order_keys;
        const TVector<TAtomicSharedPtr<TKeyScheme>> update_keys, find_keys;
        const TVector<TUpdate> updates;
        TTempDBContext dbContext;
        const bool upsert;
        TAggregationType aggregationType = TAggregationType::Concatenate;
        TMaybe<TString> shardBy;
    };
}



