#include "dns.h"
#include "../storages/dns.h"
#include <mail/so/spamstop/tools/so-common/algorithm.h>

namespace NGeneralShingler {
    TDNSScheme::TDNSScheme(TFieldSet fields, const TAtomicSharedPtr<TCacheContext> & cacheContext, const TAtomicSharedPtr<TDNS>& source)
            : TNonUpdatableCachedSchemeBase(fields, cacheContext)
            , source(source)
    { }

    TDNSScheme::~TDNSScheme() = default;

    class TDNSFuture : public TDummyFuture {
    public:
        TDNSFuture(NJson::TJsonValue::TArray array
            , TVector<TDNS::THostAlias> info
            , TAtomicSharedPtr<TDNS> source
            , const TInstant deadline
        )
            : TDummyFuture(std::move(array))
            , info(std::move(info))
            , source(std::move(source))
            , deadline(deadline)
        { }

        void DoRun(TCont* cont) override {
            simultaneous_for_each_container_with_check([](const auto& addresses, auto& item) {
                auto& resolved = item["resolved"].SetType(NJson::JSON_ARRAY).GetArraySafe();
                for (const auto& v : addresses) {
                    resolved.emplace_back(v);
                }
            }, source->Resolve(info, deadline, cont), array);
        }

        NJson::TJsonValue::TArray DoExtract() override {
            return TDummyFuture::DoExtract();
        }

    private:
        TVector<TDNS::THostAlias> info;
        TAtomicSharedPtr<TDNS> source;
        const TInstant deadline;
    };

    THolder<IFuture> TDNSScheme::InternalFind(TInstant deadline, const TShardedFields& sharded) {
        TVector<TDNS::THostAlias> info(Reserve(sharded.fields.size()));

        for (auto& item : sharded.fields) {
            info.emplace_back(item["host"].GetString(), item["alias"].GetString());
        }

        return MakeHolder<TDNSFuture>(sharded.fields, std::move(info), source, deadline);
    }
}
