#include <library/cpp/string_utils/quote/quote.h>
#include <mail/so/libs/curl/curl.h>
#include "proxy.h"

static void Process(const NCurl::TSimpleArtifacts& artifact, NJson::TJsonValue& value) {
    if (artifact.code == 200) {
        value["code"] = artifact.code;
        value["data"] = artifact.body.Str();
    }
}

namespace NGeneralShingler {
    TProxyScheme::TProxyScheme(TFieldSet fields,
                               TAtomicSharedPtr<TCacheContext> cacheContext,
                               TAtomicSharedPtr<NCurl::TStorage> storage,
                               TAtomicSharedPtr<NCurl::TPoolTraits> traits,
                               TString host)
        : TCurlScheme(std::move(fields), std::move(cacheContext), std::move(storage), std::move(traits), &Process)
        , host(std::move(host)) {
    }

    TProxyScheme::~TProxyScheme() = default;

    static TVector<NCurl::TRequestContext> CreateRequest(const NJson::TJsonValue::TArray& fields, const TString& host) {
        TVector<NCurl::TRequestContext> result(Reserve(fields.size()));

        for (const auto& item : fields) {
            auto& context = result.emplace_back();
            TStringStream request;

            request << host << '/';

            if (item.Has("request")) {
                const auto& requestConf = item["request"];
                if (!requestConf.IsString())
                    ythrow TWithBackTrace<yexception>() << "request must be string: " << requestConf;

                request << requestConf.GetString();
            }

            request << '?';

            if (item.Has("param")) {
                const auto& paramsConf = item["param"];
                if (!paramsConf.IsMap())
                    ythrow TWithBackTrace<yexception>() << "each param must be map: " << paramsConf;

                for (const auto& p : paramsConf.GetMap())
                    request << CGIEscapeRet(p.first) << '=' << CGIEscapeRet(p.second.GetString()) << '&';
            }

            context.SetHost(request.Str());

            if (item.Has("header")) {
                const auto& headersConf = item["header"];
                if (!headersConf.IsMap())
                    ythrow TWithBackTrace<yexception>() << "headers must be map: " << headersConf;

                for (const auto& p : headersConf.GetMap())
                    context.AddHeader(p.first + ':' + p.second.GetString() + "\r\n");
            }

            if (item.Has("body")) {
                const auto& bodyConf = item["body"];
                if (!bodyConf.IsMap())
                    ythrow TWithBackTrace<yexception>() << "headers must be string: " << bodyConf;

                context.SetPostData(bodyConf.GetString());
            }
        }

        return result;
    }

    void TProxyScheme::CreateFindRequests(const NJson::TJsonValue::TArray& messageFields, TVector<NCurl::TRequestContext>& requests, TInstant&) {
        requests = CreateRequest(messageFields, host);
    }

    void TProxyScheme::CreateUpdateRequests(const NJson::TJsonValue::TArray& messageFields, TVector<NCurl::TRequestContext>& requests) {
        requests = CreateRequest(messageFields, host);
    }
} // namespace NGeneralShingler
