#pragma once

#include "curl_base.h"

namespace NGeneralShingler {
    class TProxyScheme : public TCurlScheme {
    public:
        explicit TProxyScheme(TFieldSet fields,
                              TAtomicSharedPtr<TCacheContext> cacheContext,
                              TAtomicSharedPtr<NCurl::TStorage> storage,
                              TAtomicSharedPtr<NCurl::TPoolTraits> traits,
                              TString host);
        ~TProxyScheme() override;

    private:
        void CreateFindRequests(const NJson::TJsonValue::TArray& messageFields, TVector<NCurl::TRequestContext>& requests, TInstant& deadline) override;
        void CreateUpdateRequests(const NJson::TJsonValue::TArray& messageFields, TVector<NCurl::TRequestContext>& requests) override;

        TString host;
    };
} // namespace NGeneralShingler
