
#include <util/charset/utf8.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include "shingle.h"

namespace NGeneralShingler {

    THolder<IFuture> TShingleByTextScheme::Find(TInstant /*deadline*/, const TShardedFields& sharded) {
        NJson::TJsonValue::TArray results;

        for(const auto & fields : sharded.fields) {
            auto & res = results.emplace_back();
            if(!fields.Has("text") || !fields["text"].IsString()) {
                ythrow yexception() << "fields " << fields << " hasn't text field or it's not a string";
            } else {
                res["shingle"] = ToLowerUTF8(IntToString<16>(FnvHash<ui64>(fields["text"].GetString())));
            };

        }

        return MakeHolder<TDummyFuture>(std::move(results));
    }
}
