#include "short_url.h"
#include <util/string/strip.h>
#include <mail/so/libs/curl/curl.h>

namespace NGeneralShingler {
    static TString GetLocation(const NCurl::TArtifacts::THeaders& headers) {
        for (const auto& item : headers) {
            if (to_lower(item).StartsWith("location: "))
                return Strip(item.substr(strlen("location: ")));
        }

        return nullptr;
    }

    static void Process(const NCurl::TSimpleArtifacts& artifact, NJson::TJsonValue& value) {
        value["resolved"] = GetLocation(artifact.headers);
    }

    TShortUrlResolverScheme::TShortUrlResolverScheme(TFieldSet fields, const TAtomicSharedPtr<TCacheContext> & cacheContext, const TAtomicSharedPtr<NCurl::TStorage>& storage, TMaybe<TDuration> timeout)
        : TNonUpdatableScheme<TCurlScheme>(std::move(fields), cacheContext, storage, MakeAtomicShared<NCurl::TPoolTraits>(std::move(NCurl::TOptions().SetParseBody(false))), &Process)
        , timeout(timeout)
    { }

    void TShortUrlResolverScheme::CreateFindRequests(const NJson::TJsonValue::TArray& messageFields, TVector<NCurl::TRequestContext>& requests, TInstant& deadline) {
        for (const auto& item: messageFields) {
            const TString& url = item["url"].GetString();
            requests.emplace_back().SetHost(url).requestTimeout = timeout;
        }

        if (timeout.Defined())
            deadline = timeout->ToDeadLine();
    }
}
