#include "tags_info.h"

namespace NGeneralShingler {
    TTagsInfoScheme::TTagsInfoScheme(TSource source)
        : source(std::move(source))
    {
        Y_VERIFY(this->source);
    }

    class TTagsFuture : public TDummyFuture {
    public:
        TTagsFuture(NJson::TJsonValue::TArray array, TTagsInfoScheme::TSource source)
            : TDummyFuture(std::move(array)), source(std::move(source))
        { }

        void DoRun(TCont* /*cont*/) override {
            for (auto& item : array) {
                const auto tags = source->GetTags(item["value"].GetUIntegerRobust());

                if (!tags.empty()) {
                    auto& value = item["tags"].SetType(NJson::JSON_ARRAY).GetArraySafe();
                    for (const auto& tag : tags) {
                        value.emplace_back(tag);
                    }
                }
            }
        }

    private:
        TTagsInfoScheme::TSource source;
    };

    THolder<IFuture> TTagsInfoScheme::Find(TInstant /*deadline*/, const TShardedFields& sharded) {
        return MakeHolder<TTagsFuture>(std::move(sharded.fields), source);
    }
}
