#pragma once

#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include "types.h"

namespace NConfig{
    class TConfig;
}

class TLog;
class IThreadPool;
class TStorageBase;

namespace NGeneralShingler {
    class TDB {
    public:
        const TAtomicSharedPtr<TStorageBase>& GetStorage() const;

        explicit TDB(const NConfig::TConfig &config, const TAtomicSharedPtr<IThreadPool>& pool, const TAtomicSharedPtr<TLog>& logger);

    private:
        void InitDB(const NConfig::TConfig &config, const TAtomicSharedPtr<IThreadPool>& pool, const TAtomicSharedPtr<TLog>& logger);

    private:
        TDBStorageType storageType;
        TAtomicSharedPtr<TStorageBase> db;
    };

    struct TTempDBContext {
        TAtomicSharedPtr<TStorageBase> db;
        TString collection;
    };
}
