#include "dns.h"
#include <mail/so/spamstop/tools/so-common/ares.h>
#include <mail/so/libs/talkative_config/config.h>

namespace NGeneralShingler {
    TDNS::TDNS(const NConfig::TConfig &config)
        : pool(TPoolParams(config["pool"]))
        , traits(TDuration::Max(), 1, config["host"].As<TString>(nullptr))
    {
        if (config.Has("aliases")) {
            for (const auto& item : NTalkativeConfig::Get<NConfig::TDict>(config, "aliases")) {
                aliases[item.first] = "." + NTalkativeConfig::Get<TString>(item.second);
            }
        }
    }

    TVector<TVector<TString>> TDNS::Resolve(const TVector<THostAlias>& info, const TInstant& deadline, TCont* cont) {
        TVector<TString> hosts(Reserve(info.size()));
        for (const auto& item : info) {
            auto it = aliases.find(item.second);
            hosts.emplace_back(it == aliases.end() ? item.first : item.first + it->second);
        }
        return Resolve(hosts, deadline, cont);
    }

    TVector<TVector<TString>> TDNS::Resolve(const TVector<TString>& hosts, const TInstant& deadline, TCont* cont) {
        return pool.get(traits, deadline, cont)->Resolve(hosts, deadline, cont);
    }
}
