#pragma once

#include <util/generic/hash.h>
#include <util/generic/vector.h>
#include <util/generic/string.h>
#include <mail/so/spamstop/tools/so-common/ares.h>

class TCont;
namespace NConfig{
    class TConfig;
}

namespace NGeneralShingler {
    class TDNS {
    public:
        explicit TDNS(const NConfig::TConfig &config);

        using THostAlias = std::pair<TString, TString>;

        TVector<TVector<TString>> Resolve(const TVector<TString>& hosts, const TInstant& deadline, TCont* cont);
        TVector<TVector<TString>> Resolve(const TVector<THostAlias>& info, const TInstant& deadline, TCont* cont);
    private:
        NAres::TPool pool;
        NAres::TPoolTraits traits;
        THashMap<TString, TString> aliases;
    };
}
