#pragma once

#include <util/generic/hash.h>
#include <util/generic/string.h>

namespace NCurl {
    class TStorage;
}

namespace NConfig {
    class TConfig;
}

namespace NTagSets {
    template<typename, typename> class TStorage;
}

class TLog;
class IThreadPool;
class TStorageBase;
class TSimpleScheduler;

namespace NGeneralShingler {
    class TDNS;

    class TStorage {
    public:
        const TAtomicSharedPtr<TDNS>& GetDNS(const TString & name) const;
        const TAtomicSharedPtr<TStorageBase>& GetDB(const TString & name) const;
        const TAtomicSharedPtr<NCurl::TStorage>& GetCurls(const TString & name) const;
        const TAtomicSharedPtr<NTagSets::TStorage<ui64, TString>>& GetTags(const TString & name) const;

        explicit TStorage(const NConfig::TConfig &config, const TAtomicSharedPtr<IThreadPool> & pool, const TAtomicSharedPtr<TLog>& logger, TSimpleScheduler& scheduler);
        ~TStorage();

    private:
        THashMap<TString, TAtomicSharedPtr<TDNS>> dnsByName;
        THashMap<TString, TAtomicSharedPtr<TStorageBase>> dbsByName;
        THashMap<TString, TAtomicSharedPtr<NCurl::TStorage>> curlsByName;
        THashMap<TString, TAtomicSharedPtr<NTagSets::TStorage<ui64, TString>>> tagsByName;
    };
}
