PROGRAM()

OWNER(luckybug)

ALLOCATOR(LF)

SRCS(
    main.cpp
    processor.cpp
    yasm_stater.cpp
    schemes/db.cpp
    schemes/dns.cpp
    schemes/base.cpp
    schemes/proxy.cpp
    schemes/cached.cpp
    schemes/shingle.cpp
    schemes/curl_base.cpp
    schemes/short_url.cpp
    schemes/tags_info.cpp
    schemes/current_period.cpp
    storages/db.cpp
    storages/dns.cpp
    storages/tags.cpp
    storages/storage.cpp
)

ADDINCL(
    contrib/libs/tbb/include
)

CFLAGS(
    -D__TBB_NO_IMPLICIT_LINKAGE
)

PEERDIR(
    contrib/libs/tbb
    library/cpp/json
    library/cpp/string_utils/quote
    library/cpp/svnversion
    library/cpp/threading/future
    library/cpp/threading/queue
    mail/so/spamstop/tools/general_shingler/data
    mail/so/spamstop/tools/lucene_storage
    mail/so/spamstop/tools/mongoclient_v3
    mail/so/spamstop/tools/postgreclient
    mail/so/spamstop/tools/simple_shingler
    mapreduce/yt/client
    mail/so/libs/talkative_config
    mail/so/libs/syslog
    library/cpp/deprecated/atomic
)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(storages/types.h)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(schemes/types.h)

END()
