#include <util/string/builder.h>
#include <mail/so/spamstop/tools/simple_shingler/events.h>

#include "yasm_stater.h"

namespace {

const THashSet<TString> specialStatuses({NEvents::FAIL_REQ, NEvents::EXCEPTION, NEvents::MAX_CONN});

TString ToStatName(const TStringBuf &handle, const TStringBuf &status, const TVector<TString> &whitelist) {
    TStringBuilder res{};

    bool special = false;
    for (const TString &pattern : whitelist) {
      if (handle.StartsWith(pattern)) {
        res << handle << '-';
        special = true;
        break;
      }
    }
    if (!special) {
      res << "reqstats-";
    }

    if (status.length() == 3 && IsDigit(status[0]) && IsDigit(status[1]) && IsDigit(status[2])) {
        // assuming status code
        res << status[0] << "xx";
    } else if (specialStatuses.contains(status)) {
        res << status;
    } else {
        res << "other";
    }
    res << "_dmmm";
    return res;
}

} // namespace

void YasmStater::OnEvent(const TStringBuf &handle, const TStringBuf &status, Y_DECLARE_UNUSED TDuration duration) {
    TString stat = ::ToStatName(handle, status, StatedHandles);
    TGuard guard(StatsMutex);
    ++Stats[stat];
}

void YasmStater::Reply(THandleContext &&handleContext, Y_DECLARE_UNUSED void *tsr) {
    THashMap<TString, ui64> stats;
    {
        TGuard guard(StatsMutex);
        stats = Stats;
    }
    NJsonWriter::TBuf jsonWriter;

    jsonWriter.BeginList();
      for (auto const &[stat, value] : stats) {
          jsonWriter.BeginList();
          jsonWriter.WriteString(stat);
          jsonWriter.WriteULongLong(value);
          jsonWriter.EndList();
      }
    jsonWriter.EndList();

    THttpResponse(HTTP_OK)
            .SetContent(jsonWriter.Str(), "application/json")
            .OutTo(handleContext.output);
}
