#include <library/cpp/json/writer/json.h>
#include <library/cpp/http/server/response.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/system/types.h>
#include <util/system/mutex.h>

#include <mail/so/spamstop/tools/simple_shingler/handler_server.h>

class YasmStater : public THandlerFunctor, public TEventHandler {
public:
    YasmStater(const TVector<TString> &statedHandles): StatedHandles(statedHandles) {}

    void Reply(THandleContext &&handleContext, void * /* tsr */) override;
    void OnEvent(const TStringBuf& handle, const TStringBuf& status, TDuration /* duration */) override;
private:
    THashMap<TString, ui64> Stats;
    TMutex StatsMutex;
    const TVector<TString> StatedHandles;
};