#pragma once

#include <library/cpp/json/json_writer.h>
#include <util/digest/fnv.h>
#include <library/cpp/dot_product/dot_product.h>

namespace NSoKNN {

    struct TCoordinate {
        TCoordinate() = default;
        TCoordinate(TVector<int> vec) noexcept
            : Vec(std::move(vec)) {
        }

        friend NJsonWriter::TBuf& operator<<(NJsonWriter::TBuf& writer, const TCoordinate& coordinate);

        static TCoordinate FromJson(const NJson::TJsonValue& src);

        Y_SAVELOAD_DEFINE(Vec);

        TVector<int> Vec;
    };
} // namespace NSoKNN
