#pragma once

#include <mail/so/spamstop/tools/so-common/prof.h>
#include <mail/so/spamstop/tools/simple_shingler/handler_server.h>
#include <catboost/libs/cat_feature/cat_feature.h>
#include "god_object.h"

static const THashMap<TStringBuf, size_t> RulesDict = {
        {"L_COOKIE_N", 140}, {"__YANDEX_NAME", 463}, {"IS_FNAMELIST_11", 419}, {"__REPEAT_QUESTHINT_FROMIP_MAX_5", 54}, {"__MIXED_LET_MUMS", 426}, {"__DEV_ERROR", 201}, {"SPST_HIST_REJ_3", 266}, {"FNAME_ASD", 441}, {
        "MINSK_EDU_BY", 326}, {"L_COOKIE_Y", 139}, {"COMPARE_IFNAMES", 105}, {"TLD_OTHER", 69}, {"__FNAME_TYPE_1", 445}, {"COMPARE_LOGININAME", 103}, {"IS_FNAMELIST_06", 411}, {"IS_FNAMELIST_07", 413}, {
        "IS_FNAMELIST_04", 407}, {"IS_FNAMELIST_05", 409}, {"IS_FNAMELIST_02", 403}, {"IS_FNAMELIST_03", 405}, {"IS_FNAMELIST_01", 401}, {"lang_UK", 73}, {"__COUNT_PACKET4_500_MAX", 79}, {"_GEO_MOLDOVA", 478}, {
        "VALKEY1", 304}, {"IS_FNAMELIST_08", 415}, {"IS_FNAMELIST_09", 417}, {"__SYLLABLES_TO_LOGINSZ", 39}, {"__FNAME_TYPE_6", 450}, {"__FNAME_TYPE_5", 449}, {"__FNAME_TYPE_4", 448}, {"COMBINEDBL_10", 100}, {
        "COMBINEDBL_11", 101}, {"STEP1_EMPTY", 111}, {"SCORE_4_MAX", 281}, {"SAME_USAG_1200", 302}, {"__NAME_CONTINUOUS_CONSONANTS_LAT_5", 12}, {"__CAPTCHAREC_3_MAX", 128}, {"__FEMALE_FNAME", 458}, {"REQTYPE_UNCOMPLEATESETPASWD", 194}, {
        "__YANDEXFUID_10_MAX", 137}, {"__COMPLETE", 174}, {"__YANDEXFUID_30_MAX", 138}, {"__INAME_TYPE_DIGIT", 436}, {"__FNAME_TYPE_3", 447}, {"__DIGITS_TO_LOGINSZ_05", 40}, {"INAME_DIRECT_1", 315}, {"CHPASS_600", 226}, {
        "__FNAME_MIXED_LETTERS", 457}, {"REQTYPE_REGONE", 180}, {"__REPEAT_OTNSPAMALL_FROMIP_MAX_08", 64}, {"__FROM_DIRECT", 158}, {"__REPEATLOGINNSYMBIP_MAX_4", 37}, {"__REC_LEVEL_0", 337}, {"IS_INTRZONESO_LIST", 86}, {"V2_TMNG5_5_MAX", 361}, {
        "YS_COOKIE_Y", 145}, {"__NAME_CONT_VOWELS_EXCLUDE", 15}, {"PDD_ESY", 521}, {"IP_MOBTEST", 318}, {"__EMPTY_BODYTEXT", 339}, {"IS_WHITESO_LIST", 85}, {"V2_TMNG6_5_MAX", 362}, {"__YANDEXUID_5", 130}, {
        "__FNAME_CONT_VOWS", 23}, {"__SCOAVERAGE_FROMHOUR_MAX_05", 50}, {"YS_COOKIE_N", 146}, {"STAT_NEW_INAME", 210}, {"NO_FROM", 152}, {"__STEP2_EMPTY", 115}, {"EQUAL_FIRST_NSYMB_1200", 289}, {"V2_TMNG1_5_MAX", 354}, {
        "SPST_HIST_SPAM_10", 265}, {"__FROM_PDD", 160}, {"PHON_NARODMAPS", 374}, {"__STAT_NEW_IP", 202}, {"IS_NICKNAME_300", 296}, {"L_SUGGESTED", 125}, {"__INAME_MIXED_LETTERS", 456}, {"V2_SUGGEST_LOGIN_1", 352}, {
        "REQTYPE_POSTREGISTRATION", 190}, {"SPST_TODAY_RBL", 251}, {"UA_ANDROID", 380}, {"PHONE_CONFIRMED", 364}, {"V2_ZONE_MOSCOW", 244}, {"RATWARE_UAGENT", 333}, {"AC_MANAGER_SDK_0", 331}, {"__STEP1_1001_MAX", 110}, {
        "REQTYPE_CHANGEPASS", 183}, {"STAT_MALIC_FNAME", 220}, {"POP3_SPAM_IP", 497}, {"COMPARE_LOGINNAMES", 102}, {"PACK3_300", 286}, {"IS_INAMELIST_04", 387}, {"_GEO_GERMANY", 477}, {"V2_PASS_QUALITY_0_40", 234}, {
        "__STEP1_MIN_10", 107}, {"SAME_USAG_1200_20", 303}, {"__ADDITHINT_MAX_4", 27}, {"__FNAME_TYPE_DASH", 453}, {"V2_PASS_DIVERGED", 237}, {"IS_WHITE_LIST", 82}, {"__STEP2_SPEC_MODE", 116}, {"US_PHONE", 121}, {
        "V2_TMNG4_20_MAX", 360}, {"__HOST_2L_100_MAX", 66}, {"V2_PASS_QUALITY_36_55", 235}, {"NUMS_END_LGN", 273}, {"REQTYPE_ALTERNATIVEPHONE", 193}, {"__LOGIN_LONG_MAX12", 30}, {"__STEP1_MIN_5", 106}, {"EMPTY_UAGENT", 332}, {
        "SPAM_UAGENT", 335}, {"SPST_HIST_NOREJ_MIN_5", 267}, {"FNAME_DIRECT_1", 316}, {"lang_EN", 72}, {"RU_PHONE", 118}, {"__FRAUD_NAME_MD", 468}, {"SAME_USAG_300", 300}, {"__ED_CENTER_COMP", 321}, {
        "_GEO_BY", 481}, {"IP_CHPASS_1200", 231}, {"PDD_BOXES_5K", 508}, {"STAT_INAME_OTN_SPAM_06", 222}, {"HURRICANE_IP", 378}, {"IS_INAMELIST_07", 393}, {"SPST_YTD_MALIC_10", 262}, {"EQUAL_PREFIX_LOGIN_300", 290}, {
        "AC_MANAGER_UAGENT", 329}, {"__CONT_CONSONANTS_LAT_EXCLUDE", 11}, {"BAD_GEO_ZONE_EAST", 488}, {"__PREFIXLOGIN_LONG_MAX5", 34}, {"__REPEAT_SPAMREG_FROMIP_MAX_2", 61}, {"__REPEAT_SPAMREG_FROMIP_MAX_5", 60}, {"__FRAUD_LOGIN_MD", 469}, {"STAT_SPAM_IFNAME", 218}, {
        "CHPASS_300", 225}, {"V2_TMNG4_20", 359}, {"IS_TRUSTZONESO_LIST", 87}, {"__FROM_NAROD", 155}, {"POSTREG_1200", 283}, {"SPST_TD_MALIC_10", 258}, {"__SIMPLEREG", 173}, {"CONS_NOT_PASSPORT", 165}, {
        "__LOGIN_LONG_MIN5", 32}, {"__REPEAT_PASSWHINT_FROMIP_MIN_5", 51}, {"V2_PAGE_LOADING", 245}, {"_GEO_99999", 483}, {"STAT_NEW_IFNAME", 212}, {"COMPARE_LOGINFNAME", 104}, {"MY_COOKIE_N", 144}, {"FUID_NARODMAPS_3", 371}, {
        "TEST_SPAM_LOGIN", 275}, {"__REPEATLOGINPREFIXIP_MAX_4", 36}, {"__INAME_TYPE_SPACE", 437}, {"REQTYPE_ADMSOCIALREG", 181}, {"EDU_BY", 327}, {"__FNAME_TYPE_2", 446}, {"SPST_YESTERDAY_RBL", 255}, {"SHORT_SESSION_AGE", 367}, {
        "SPST_YESTERDAY_WHITE", 254}, {"IS_LOCALZONESO_LIST", 88}, {"__LOGIN_LONG_MAX5", 28}, {"SEO_USAG", 324}, {"WOGER_NETS", 495}, {"__SERIAL_COUNT_SCOMO_MAX_5", 49}, {"__STEP1_SPEC_MODE", 112}, {"TEST_SPAM_LOGIN_2_1", 276}, {
        "REQTYPE_REGISTER", 176}, {"__VZLOM_NAMES", 471}, {"FUID_NARODMAPS_4", 372}, {"__STAT_OTN_SPAM_09", 209}, {"V2_PASS_QUALITY_100", 233}, {"__REPEAT_ANSWERHINT_FROMIP_MAX_5", 56}, {"__DEV_SPAM", 199}, {"__INAME_TYPE_6", 435}, {
        "POSTREG_300", 282}, {"__INAME_TYPE_4", 433}, {"__INAME_TYPE_5", 434}, {"__STAT_OTN_SPAM_01", 206}, {"VALKEY7", 310}, {"__STAT_OTN_SPAM_05", 207}, {"__LOGIN_HAS_HYPHEN", 424}, {"DIFF_UID_LUID", 150}, {
        "IS_UNGRUPPEDIP_LIST", 84}, {"__LOGIN_NO_CAPS", 421}, {"HAS_EMAIL", 26}, {"__LOGIN_LONG_MAX20", 31}, {"HOST_FARLINE", 494}, {"TM_DIFF_2_MAX", 500}, {"__VOWELS_COUNT_MAX_3", 8}, {"CONS_KOPALKA", 164}, {
        "SPST_YTD_SP_075", 263}, {"IS_BLACK_LIST", 81}, {"SPST_YTD_SPAM_10", 261}, {"V2_CAPT_CHECK_2_MAX", 346}, {"__CONSTANANTS_COUNT_MAX_5", 10}, {"REQTYPE_ADMREG", 182}, {"RPATH_CERTWL_10", 97}, {"VALKEY6", 309}, {
        "__INAME_CONT_CONS", 20}, {"__LOGIN_LONG_8", 33}, {"KAZAN_SCHOOL_COMP", 320}, {"__COUNT_PACKET5_5000_MAX", 80}, {"V2_PASS_MESH_CNT_2_MAX", 236}, {"REQTYPE_COMPLETE", 196}, {"__STEP2_MIN_10", 114}, {"SUPPORT_LOGIN_BAN", 462}, {
        "_GEO_AZ", 479}, {"__COUNT_PACKET2_MIN_5", 76}, {"REQTYPE_CHANGE_PASSWORD", 185}, {"__CAPTCHACNT_5_MAX", 126}, {"__REPEAT_ALLREG_FROMIP_MAX_5", 59}, {"V2_COUNTRY_US", 243}, {"__UNUSABLE_MSGID", 336}, {"__NAME_CONT_VOWELS_EXCLUDE_RU", 16}, {
        "IS_INAMELIST_10", 398}, {"TEST_SPAM_LOGIN_7", 277}, {"IS_INAMELIST_12", 400}, {"V2_COUNTRY_UA", 240}, {"TEST_SPAM_LOGIN_8", 278}, {"__FROM_MAIL", 154}, {"TEST_SPAMERS_300", 284}, {"COMBINEDBL_8", 94}, {
        "COMBINEDBL_9", 99}, {"COMBINEDBL_6", 93}, {"HW_ID_2", 168}, {"COMBINEDBL_4", 91}, {"COMBINEDBL_5", 92}, {"COMPLETE_PDD", 175}, {"COMBINEDBL_0", 89}, {"HW_ID_4", 170}, {
        "LOGIN_DIRECT_1", 314}, {"__COUNT_IFNAME_FROMIP_MAX_3", 7}, {"PDD_KARMA_BAD", 514}, {"EQUAL_FIRST_NSYMB_300", 288}, {"YANDEXWL_1", 95}, {"YANDEXWL_2", 96}, {"SPST_TD_SP_075", 259}, {"__COUNT_PACKET4_MIN_05", 78}, {
        "__STAT_SPAM_IP", 204}, {"BAD_GEO_ZONE_AFR", 485}, {"__YANDEXUID", 131}, {"__FROM_FRIENDS", 156}, {"__YANDEXUID_2000", 134}, {"IS_FNAMELIST_10", 418}, {"GEO_AS_100_MAX", 271}, {"FUID_NARODMAPS", 369}, {
        "REQTYPE_COMPLEATE_PDD", 195}, {"__REPEAT_TOTALFROMIP_MAX_100", 46}, {"PDD_DOMN_500", 503}, {"__CONSTANANTS_DIGITS_COUNT_MAX_5", 17}, {"_GEO_UA", 480}, {"__INAME_TYPE_1", 430}, {"STAT_MALIC_IFNAME", 221}, {"IS_FNAMELIST_TRSC_08", 416}, {
        "__COUNT_REG_FROMIP_LAST5MIN_MAX_3", 1}, {"__REPEAT_OTNSPAMALL_FROMIP_MAX_04", 63}, {"__COUNT_REG_FROMIP_LAST10MIN_MIN_5", 2}, {"V2_COUNTRY_BY", 242}, {"__STAT_MALIC_IP", 205}, {"__COUNT_PACKET1_3_MAX", 75}, {"IS_FNAMELIST_TRSC_01", 402}, {"IS_FNAMELIST_TRSC_02", 404}, {
        "IS_PHONE_300", 298}, {"IS_FNAMELIST_TRSC_04", 408}, {"IS_FNAMELIST_TRSC_05", 410}, {"__NAME_CONT_PATTERN", 19}, {"IS_FNAMELIST_TRSC_07", 414}, {"__INAME_TYPE_2", 431}, {"PETROV", 279}, {"LONG_SESSION_AGE", 366}, {
        "BAD_GEO_ZONE_LA", 486}, {"SPST_TODAY_WHITE", 250}, {"LOGIN_L_L_D", 429}, {"QID_CUSTOM", 57}, {"__FROM_MK", 157}, {"PDD_000SPACE", 501}, {"GTUBE", 475}, {"V2_PASS_VALID_2", 348}, {
        "__REPEAT_TOTALFROMIP_MIN_11", 43}, {"IS_PDD", 340}, {"REQTYPE_UNKNOWN", 178}, {"CHPASS_3600", 228}, {"PDD_QUOTA_1111", 510}, {"SQUAREYARDS", 328}, {"SPAM_V6_NETS", 377}, {"__REPEAT_OTNSPAMALL_FROMIP_MIN_01", 62}, {
        "__INAME_TYPE_3", 432}, {"REQTYPE_CHANGE_PASSWORD_FORCE", 186}, {"V2_TMNG4_3", 357}, {"VALKEY3", 306}, {"VALKEY2", 305}, {"VALKEY5", 308}, {"VALKEY4", 307}, {"LANG_", 74}, {
        "__PREFIXLOGIN_LONG_MIN5", 35}, {"VALKEY9", 312}, {"VALKEY8", 311}, {"__INAME_CONT_VOWS", 22}, {"SPAM_AS", 492}, {"IS_INAMELIST_11", 399}, {"YP_COOKIE_N", 148}, {"__FNAME_TYPE_SPACE", 452}, {
        "TOR_DNS", 375}, {"STAT_HAM_INAME", 213}, {"__DEV_ALL", 198}, {"TLD_IN_LOGIN", 522}, {"__LOGIN_LONG_MAX10", 29}, {"AC_MANAGER_SDK", 330}, {"OPER_UAGENT", 325}, {"PACK3_1200", 287}, {
        "YP_COOKIE_Y", 147}, {"__NO_LCHECK", 123}, {"FROM_GALATASARAY", 163}, {"HOST_UKRTEL", 493}, {"__FNAME_TYPE_DIGIT", 451}, {"VALKEY10", 313}, {"__COUNT_PACKET3_500_MAX", 77}, {"__INAME_DIGITS", 24}, {
        "__COUNT_FNAME_FROMIP_MAX_5", 6}, {"TLD_TR", 68}, {"RU_PHONE_9", 119}, {"IS_GRUPPEDIP_LIST", 83}, {"SPST_TD_HAM_0", 256}, {"REQTYPE_LIGHTREGISTER", 179}, {"V2_PAGE_LOADING_CSS", 246}, {"__FNAME_SINGLE_LETTER", 455}, {
        "lang_RU", 70}, {"EQUAL_PREFIX_LOGIN_1200", 291}, {"__STEP1_EMPTY_ERROR", 113}, {"V2_COUNTRY_RU", 238}, {"__INAME_TYPE_JUNK", 439}, {"PDD_ADMIN_MAL", 516}, {"__FROM_MAPS", 161}, {"STAT_SPAM_FNAME", 217}, {
        "STAT_IFNAME_OTN_SPAM_05", 224}, {"__SUPPORT_LOGIN", 461}, {"APP_RU_NAVI", 524}, {"__REPEAT_TOTALFROMIP_MIN_3", 41}, {"V2_LOGIN_VALID_1", 342}, {"V2_LOGIN_VALID_2", 343}, {"__STEP1_120_MAX", 109}, {"PHONE_CONFIRM_LIMIT", 365}, {
        "PDD_IP_TUT", 512}, {"__INAME_SINGLE_LETTER", 442}, {"SPST_HIST_SP_075", 268}, {"IS_EMAIL_300", 294}, {"__HURRICANE_IP", 379}, {"EQUAL_IFNAME_300", 292}, {"V2_LOGIN_VALID_10_MAX", 345}, {"__COUNT_REG_FROMIP_LAST10MIN_MAX_5", 3}, {
        "__REPEAT_QUESTHINT_FROMIP_MIN_5", 53}, {"PDD_MANUAL_REG", 519}, {"SPST_TODAY_AUTOBAN", 248}, {"MTS_NN", 496}, {"BAD_GEO_HOST", 490}, {"HW_ID_3", 169}, {"PDD_3L", 520}, {"STAT_SPAM_INAME", 216}, {
        "HW_ID_1", 167}, {"__COUNT_REG_FROMIP_LASTHOUR_MAX_10", 4}, {"HW_ID_0", 166}, {"PDD_KARMA_GOOD", 513}, {"COMBINEDBL_2", 90}, {"SAME_USAG_300_5", 301}, {"V2_TMNG4_10", 358}, {"PDD_AGE_3", 504}, {
        "STAT_NEW_FNAME", 211}, {"STAT_FNAME_OTN_SPAM_06", 223}, {"CSA_HOST", 98}, {"IS_FNAMELIST_TRSC_03", 406}, {"HAS_PHONE", 117}, {"LOGIN_ASD", 427}, {"PDD_ADMIN_ASD", 511}, {"SPAM_NAMES", 472}, {
        "PDD_DOMN_10", 502}, {"__LCHECK_10_MAX", 124}, {"CONT_PATTERN", 18}, {"IS_EMAIL_1200", 295}, {"VYMPELCOM_COMP", 319}, {"STAT_HAM_FNAME", 214}, {"lang_TR", 71}, {"SPST_TD_SPAM_10", 257}, {
        "DIFF_L_LOGIN", 149}, {"UA_PHONE", 120}, {"IP_CHPASS_600", 230}, {"__REPEAT_TOTALFROMIP_MIN_3_2", 42}, {"V2_COUNTRY_KZ", 241}, {"REQTYPE_CHANGEPASS_BASE", 184}, {"__REPEAT_DIGITSCOUNT_MAX_5", 38}, {"GTUBE_STRONG", 476}, {
        "__YANDEXUID_1000", 133}, {"__FNAME_CONT_CONS", 21}, {"SPST_YESTERDAY_AUTOBAN", 252}, {"NO_GEO", 489}, {"SPST_YESTERDAY_MANUALBAN", 253}, {"STAT_HAM_IFNAME", 215}, {"IPV6", 322}, {"MEGAFON", 498}, {
        "IS_NICKNAME_1200", 297}, {"V2_TMNG2_5_MAX", 355}, {"__NAME_CONT_CONS_EXCLUDE", 13}, {"L_COOKIE_AGE_5", 151}, {"SCORE_3_MAX", 280}, {"__CONT_VOWELS_LAT_EXCLUDE", 9}, {"V2_LOGIN_VALID_3_MAX", 344}, {"__STEP1_60_MAX", 108}, {
        "SPST_YTD_HAM_0", 260}, {"NAME_MOBTEST", 317}, {"__COUNT_INAME_FROMIP_MAX_5", 5}, {"__HOST_3L_100_MAX", 67}, {"GEO_CNT_300_MAX", 270}, {"__CAPTCHACNT_10_MAX", 127}, {"INAME_ASD", 440}, {"SAME_URI_100", 341}, {
        "NO_YANDEXUID", 129}, {"REQTYPE_CHANGE_PASSWORD_VOLUNTARILY", 188}, {"__REPEAT_TOTALFROMIP_MAX_150", 47}, {"IS_INAMELIST_TRSC_03", 386}, {"IS_INAMELIST_TRSC_02", 384}, {"IS_INAMELIST_TRSC_01", 382}, {"IS_INAMELIST_TRSC_07", 394}, {"IS_INAMELIST_TRSC_06", 392}, {
        "IS_INAMELIST_TRSC_05", 390}, {"IP_CHPASS_300", 229}, {"__FRAUD_LOGIN_NO", 467}, {"SPST_HIST_HAM_0", 264}, {"IS_INAMELIST_TRSC_08", 396}, {"__LOGIN_LAST_CAPS", 422}, {"MY_COOKIE_Y", 143}, {"__STAT_OTN_SPAM_075", 208}, {
        "__FNAME_TYPE_JUNK", 454}, {"V2_SUGGEST_LOGIN_15_MAX", 353}, {"__ACT_CH_PASS", 172}, {"REQTYPE_ADMIMPORTREG", 177}, {"REQTYPE_PHONEREG", 191}, {"IS_FNAMELIST_TRSC_06", 412}, {"BAD_GEO_ZONE_EUR", 487}, {"__FRAUD_NAME", 464}, {
        "__REPEAT_PASSWHINT_FROMIP_MAX_5", 52}, {"__REPEAT_TOTALFROMIP_MAX_30", 45}, {"__FNAME_DIGITS", 25}, {"PHONE_LOGIN", 473}, {"__VZLOM_LOGIN", 470}, {"__YANDEXUID_500", 132}, {"V2_PASS_VALID_MIN_3", 347}, {"HOST_NARODMAPS", 373}, {
        "__MALE_FNAME", 459}, {"PDD_GEO_TR", 517}, {"__REPEAT_ALLREG_FROMIP_MIN_5", 58}, {"IS_INAMELIST_06", 391}, {"IS_INAMELIST_05", 389}, {"V2_PASS_VALID_5_MAX", 350}, {"IS_INAMELIST_03", 385}, {"IS_INAMELIST_02", 383}, {
        "IS_INAMELIST_01", 381}, {"__BAD_GEO_ZONE", 484}, {"__ACT_ADMREG", 171}, {"__YANDEXFUID_5_MAX", 136}, {"__FNAME_4WORDS", 444}, {"IS_INAMELIST_09", 397}, {"IS_INAMELIST_08", 395}, {"_GEO_TURKEY", 482}, {
        "__INAME_4WORDS", 443}, {"IS_FNAMELIST_12", 420}, {"TM_NIGHT", 499}, {"__NAME_CONTINUOUS_VOWELS_LAT_3", 14}, {"__INAME_TYPE_DASH", 438}, {"REQTYPE_SIMPLEREG", 189}, {"FUID_NARODMAPS_2", 370}, {"ALARM_TIMING_NEGATIVE", 363}, {
        "APP_RU_MAIL", 525}, {"PDD_AGE_10", 505}, {"REPEAT_TOTALFROMIP_MAX_1000", 48}, {"REQTYPE_ALTERNATIVEHINT", 192}, {"IP_LACNIC", 491}, {"DUBLICAT_LOGIN_MAX_1", 65}, {"PDD_ADMIN_BAD", 515}, {"SPST_TODAY_MANUALBAN", 249}, {
        "__LOGIN_HAS_DIGIT", 423}, {"TOR_RBL", 376}, {"REQTYPE_CHANGE_PASSWORD_STRONG", 187}, {"IS_INAMELIST_TRSC_04", 388}, {"SEO_LOGIN", 474}, {"TLD_3LVL_IN_LOGIN", 523}, {"GEO_AS_500_MAX", 272}, {"LCHECK_1", 122}, {
        "__MESS_NO_BODY", 338}, {"IP_CHPASS_3600", 232}, {"CHPASS_1200", 227}, {"GEO_CITY_CNT_100_MAX", 269}, {"SPST_NODATA", 247}, {"REQTYPE_DIRECTORYREG", 197}, {"V2_TMNG3_5_MAX", 356}, {"V2_PASS_VALID_1", 349}, {
        "MAIL_IN_LOGIN", 425}, {"__COUNT_PACKET1_50_MAX", 274}, {"PDD_AGE_30", 506}, {"__DEV_HAM", 200}, {"PDD_FREE_REG", 518}, {"PDD_BOXES_1111", 507}, {"STAT_MALIC_INAME", 219}, {"V2_PASS_VALID_10_MAX", 351}, {
        "__FRAUD_LOGIN", 465}, {"FUID_NOT_EMPTY", 368}, {"__REPEAT_ANSWERHINT_FROMIP_MIN_5", 55}, {"PDD_BOXES_MIN_10", 509}, {"MASS_USAG", 323}, {"__YANDEXFUID_2_MAX", 135}, {"YALOGIN_COOKIE_N", 142}, {"__STAT_HAM_IP", 203}, {
        "EQUAL_IFNAME_1200", 293}, {"__NOT_FROM_MAIL", 153}, {"LOGIN_ZHAR", 428}, {"V2_COUNTRY_TR", 239}, {"TEST_SPAMERS_1200", 285}, {"__SUPPORT_NAME", 460}, {"__REPEAT_TOTALFROMIP_MAX_5", 44}, {"MAC_IN_UAGENT", 334}, {
        "YALOGIN_COOKIE_Y", 141}, {"__FROM_WIKIMAPS", 162}, {"FRAUD_LOGIN_STRONG", 466}, {"IS_PHONE_1200", 299}, {"__FROM_SOCIAL", 159}, {"X_X_X", 0}};

static const TVector<TString> NumericFeatures = {"v2_password_quality", "v2_login_validation_count", "v2_password_validation_count", "clst_distance", "clst_radius_max", "clst_radius_min", "clst_spam_percent"};

class TFrodoHandler : public THandlerFunctor {
public:
    void Reply(THandleContext && handleContext, void*) override {


        const auto reqData = handleContext.ExtractData();

        const auto & cgi = TCgiParameters(TStringBuf(static_cast<const char*>(reqData.Data()), reqData.Size()));
        const auto numeric = [&cgi] {
            TVector<float> features(RulesDict.size() + NumericFeatures.size(), 0.f);

            //numeric
            {
                for(size_t i = 0; i < NumericFeatures.size(); i++) {
                    const auto & f = NumericFeatures[i];
                    auto it = cgi.find(f);

                    if(it != cend(cgi)) {
                        if(it->second == "v2_password_quality")
                            features[i] = FromString<float>(it->second) / 100;
                        else
                            features[i] = FromString<float>(it->second);
                    }
                }
            }
            //rules
            {
                auto it = cgi.find("rules");
                if(it != cend(cgi)) {
                    const TSplitDelimiters delimiters(",");
                    const TDelimitersSplit splitter(it->second, delimiters);

                    auto tok = splitter.Iterator();
                    while (!tok.Eof()) {
                        auto ruleIt = RulesDict.find(tok.NextTok());
                        if (ruleIt != cend(RulesDict))
                            features[NumericFeatures.size() + ruleIt->second] = 1.f;
                    }
                }
            }
            return features;
        }();

        const auto categorial = [&cgi] {
            auto rtypeIt = cgi.find("rtype");
            auto geoIt = cgi.find("geo");
            auto langIt = cgi.find("lang");
            return TVector<int>{
                    CalcCatFeatureHashInt((rtypeIt == cend(cgi) ? "ALTERNATIVEHINT" : TStringBuf{rtypeIt->second})),
                    CalcCatFeatureHashInt((geoIt == cend(cgi) ?   "ru" : TStringBuf{geoIt->second})),
                    CalcCatFeatureHashInt((langIt == cend(cgi) ?  "lang_ru" : TStringBuf{langIt->second})),
                    CalcCatFeatureHashInt("catf_3"),
                    CalcCatFeatureHashInt("catf_4"),
                    CalcCatFeatureHashInt("catf_5"),
                    CalcCatFeatureHashInt("catf_6"),
                    CalcCatFeatureHashInt("catf_7"),
                    CalcCatFeatureHashInt("catf_8"),
                    CalcCatFeatureHashInt("catf_9"),
            };
        }();


        const auto & model = godObject->GetCheckFormModel();

        TVector<double> predicted{0.};
        model.Calc(numeric, categorial, predicted);

        const auto proba = 1.0 / (1.0 + std::exp(-predicted.front()));

        TString res;
        {
            TStringOutput stream(res);
            stream << "<weight>" << static_cast<int>(100 * proba) << "</weight><spam>" << static_cast<int>(predicted.front()) << "</spam>";
        }

        THttpResponse(HTTP_OK).SetContent(std::move(res)).OutTo(handleContext.output);
    }

    TFrodoHandler(TSimpleSharedPtr<const TGodObject> godObject) noexcept : godObject(std::move(godObject)) {}
    const TSimpleSharedPtr<const TGodObject> godObject;
};

