#pragma once

#include <mail/so/spamstop/tools/so-common/prof.h>
#include <mail/so/spamstop/tools/simple_shingler/handler_server.h>
#include "mlp_solver.h"
#include "god_object.h"

class TStatsConsumer;

class TGetTopThemesHandler : public THandlerFunctor {
public:
    void Reply(THandleContext && handleContext, void* tsr) override;

    explicit TGetTopThemesHandler(TSimpleSharedPtr<const TGodObject> godObject) noexcept : godObject(std::move(godObject)) {};
private:
    static std::tuple<NLSA::TMatrix, double, NLSA::TMatrix, double> CreateDocCoordinateFromWordCoordinates(const TVector<const NLSA::TW2VTrait *> & coordinates);
    const TSimpleSharedPtr<const TGodObject> godObject;
};
