#include "app.h"

#include <library/cpp/http/server/response.h>
#include <library/cpp/svnversion/svnversion.h>

#include <mail/so/spamstop/tools/simple_shingler/tsr.h>
#include <mail/so/spamstop/tools/so-common/hist.h>
#include <mail/so/spamstop/tools/so-common/yasm_stat.h>
#include <mail/so/spamstop/tools/so-clients/tshinglerenv.h>
#include <util/system/rwlock.h>
#include <mail/so/spamstop/tools/so-common/stats_consumer.h>
#include <mail/so/libs/talkative_config/config.h>
#include "TGetTopThemesHandler.h"
#include "TFrodoHandler.h"
#include "w2v_handler.h"


static const THashMap<TString, TVector<TDuration>> levelsBySignal = {
        {"gtt", {
                        TDuration::MilliSeconds(1),
                        TDuration::MilliSeconds(3),
                        TDuration::MilliSeconds(5),
                        TDuration::MilliSeconds(10),
                        TDuration::MilliSeconds(30),
                        TDuration::MilliSeconds(50),
                        TDuration::MilliSeconds(100),
                        TDuration::MilliSeconds(300),
                        TDuration::MilliSeconds(500),
                        TDuration::Seconds(1),
                }},
        {"vw", {
                        TDuration::MilliSeconds(1),
                        TDuration::MilliSeconds(2),
                        TDuration::MilliSeconds(3),
                        TDuration::MilliSeconds(4),
                        TDuration::MilliSeconds(5),
                        TDuration::MilliSeconds(6),
                        TDuration::MilliSeconds(7),
                        TDuration::MilliSeconds(8),
                        TDuration::MilliSeconds(9),
                        TDuration::MilliSeconds(10),
                        TDuration::MilliSeconds(15),
                        TDuration::MilliSeconds(20),
                }},
        {"dssm", {
                        TDuration::MilliSeconds(1),
                        TDuration::MilliSeconds(2),
                        TDuration::MilliSeconds(3),
                        TDuration::MilliSeconds(4),
                        TDuration::MilliSeconds(5),
                        TDuration::MilliSeconds(6),
                        TDuration::MilliSeconds(7),
                        TDuration::MilliSeconds(8),
                        TDuration::MilliSeconds(9),
                        TDuration::MilliSeconds(10),
                        TDuration::MilliSeconds(15),
                        TDuration::MilliSeconds(20),
                }},
        {"tabs", {
                        TDuration::MilliSeconds(1),
                        TDuration::MilliSeconds(2),
                        TDuration::MilliSeconds(3),
                        TDuration::MilliSeconds(4),
                        TDuration::MilliSeconds(5),
                        TDuration::MilliSeconds(6),
                        TDuration::MilliSeconds(7),
                        TDuration::MilliSeconds(8),
                        TDuration::MilliSeconds(9),
                        TDuration::MilliSeconds(10),
                        TDuration::MilliSeconds(15),
                        TDuration::MilliSeconds(20),
                }},
        {"ng_tab", {
                        TDuration::MilliSeconds(1),
                        TDuration::MilliSeconds(2),
                        TDuration::MilliSeconds(3),
                        TDuration::MilliSeconds(4),
                        TDuration::MilliSeconds(5),
                        TDuration::MilliSeconds(6),
                        TDuration::MilliSeconds(7),
                        TDuration::MilliSeconds(8),
                        TDuration::MilliSeconds(9),
                        TDuration::MilliSeconds(10),
                        TDuration::MilliSeconds(15),
                        TDuration::MilliSeconds(20),
                }},
        {"compls_distance", {
                        TDuration::MilliSeconds(1),
                        TDuration::MilliSeconds(2),
                        TDuration::MilliSeconds(3),
                        TDuration::MilliSeconds(4),
                        TDuration::MilliSeconds(5),
                        TDuration::MilliSeconds(6),
                        TDuration::MilliSeconds(7),
                        TDuration::MilliSeconds(8),
                        TDuration::MilliSeconds(9),
                        TDuration::MilliSeconds(10),
                        TDuration::MilliSeconds(15),
                        TDuration::MilliSeconds(20),
                }},
        {"old_themes", {
                        TDuration::MilliSeconds(1),
                        TDuration::MilliSeconds(2),
                        TDuration::MilliSeconds(3),
                        TDuration::MilliSeconds(4),
                        TDuration::MilliSeconds(5),
                        TDuration::MilliSeconds(6),
                        TDuration::MilliSeconds(7),
                        TDuration::MilliSeconds(8),
                        TDuration::MilliSeconds(9),
                        TDuration::MilliSeconds(10),
                        TDuration::MilliSeconds(15),
                        TDuration::MilliSeconds(20),
                }},
        {"json_parsing", {
                        TDuration::MilliSeconds(1),
                        TDuration::MilliSeconds(2),
                        TDuration::MilliSeconds(3),
                        TDuration::MilliSeconds(4),
                        TDuration::MilliSeconds(5),
                        TDuration::MilliSeconds(6),
                        TDuration::MilliSeconds(7),
                        TDuration::MilliSeconds(8),
                        TDuration::MilliSeconds(9),
                        TDuration::MilliSeconds(10),
                        TDuration::MilliSeconds(15),
                        TDuration::MilliSeconds(20),
                }},
};

void ProfHandler(THandleContext&& handleContext, void* tsr) {
    auto context = reinterpret_cast<TProfiledContext::TExecutionContext*>(tsr);
    NJsonWriter::TBuf jsonWriter;
    {
        const THashMap<TString, THist<TDuration>> namedTimeHist = context->Master.MakeHist(levelsBySignal);
        jsonWriter.BeginList();
        ToJson(namedTimeHist, jsonWriter);
        jsonWriter.EndList();
    }
    THttpResponse(HTTP_OK).SetContent(jsonWriter.Str(), "application/json").OutTo(handleContext.output);
}

THolder<THttpServer> RunLsaApp(const NConfig::TConfig& config) {
    Y_VERIFY(config["ml"].IsA<NConfig::TDict>());
    const auto godObject = MakeSimpleShared<const TGodObject>(config["ml"]);

    Y_VERIFY(config["server"].IsA<NConfig::TDict>());
    auto server = MakeHolder<TContextServer<TProfiledContext>>(TServerOptions::ReadOptionsFromConfig(NTalkativeConfig::Get<NConfig::TDict>(config, "server")));

    auto log = MakeAtomicShared<TLog>(CreateOwningThreadedLogBackend("cerr"));

    auto pingHandler = MakeAtomicShared<TPingHandler>();
    server
            ->On("/lsa_get_top_themes", MakeAtomicShared<TGetTopThemesHandler>(godObject))
            .On("/frodocf", MakeAtomicShared<TFrodoHandler>(godObject))
            .On("/word_stat", MakeAtomicShared<TW2VHandler>(godObject))
            .On("/yasm", ProfHandler)
            .On("/ping", pingHandler)
            .On("/rotatelogs", [&server, log](THandleContext&& handleContext, void* /*tsrt*/) {
                server->ReopenLog();
                log->ReopenLog();
                handleContext.output << THttpResponse().SetContent("Ok");
            })
            .On("/stop", MakeAtomicShared<TStopServerHandler>(server.Get(), pingHandler));

    Y_VERIFY(server->Start());

    return server;
}
