#pragma once

#include <utility>

#include <util/generic/vector.h>
#include <util/folder/path.h>
#include <util/generic/hash.h>
#include <kernel/dssm_applier/nn_applier/lib/layers.h>
#include <kernel/dssm_applier/nn_applier/lib/states.h>
#include <mail/so/spamstop/tools/lsa/data/dictionary.h>
#include <mail/so/spamstop/tools/lsa/data/theme_tree.h>
#include <mail/so/spamstop/tools/lsa/data/hnsw.h>
#include <library/cpp/vowpalwabbit/vowpal_wabbit_model.h>
#include <util/system/rwlock.h>
#include <catboost/libs/model/model.h>
#include <mail/so/spamstop/tools/lsa/data/tabs.h>
#include <mail/so/spamstop/tools/lsa/data/transfer.h>
#include <mail/so/libs/lsa_projectors/field_projectors.h>
#include <mlp/mail/tabs/tabs_model.h>
#include "solver.h"

namespace NConfig{
    class TConfig;
}

class TFeaturesMapper{
public:
    NLSA::TPredictionsMap MakePredictionsMap(const TVector<float>& predictions) const;
    static TFeaturesMapper FromConfig(const NConfig::TConfig& config, size_t maxIndex = std::numeric_limits<size_t>::max());

private:
    THashMap<size_t, TString> map;
};

class IProjector{
public:
    virtual const TString& Apply(float value) const = 0;
    virtual ~IProjector() = default;
};

class TRangeProjector : public IProjector{
public:
    static TRangeProjector FromConfig(const NConfig::TConfig& config);
    const TString& Apply(float value) const final;

private:
    float LowerBound = 0.f;
    float UpperBound = 1.f;
    TString Feature;
};

class TProjectorsMapper{
public:
    TVector<TString> MakeFeatures(const TVector<float>& predictions) const;
    static TProjectorsMapper FromConfig(const NConfig::TConfig& config, size_t maxIndex = std::numeric_limits<size_t>::max());

private:
    THashMap<size_t, TVector<THolder<IProjector>>> map;
};

class TVWModelWithInfo : public NVowpalWabbit::TModel {
public:

    const TVector<NLSA::TProjectorField>& GetHeaders() const {
        return headers;
    }

    ui8 GetNgram() const {
        return ngram;
    }

    TVWModelWithInfo(const TBlob &weights, TFeaturesMapper mapper, TProjectorsMapper projectorsMapper,
                     TVector<NLSA::TProjectorField> headers, ui8 ngram)
            : NVowpalWabbit::TModel(weights), mapper(std::move(mapper)), projectorsMapper(std::move(projectorsMapper)),
              headers(std::move(headers)), ngram(ngram) {}

    TFeaturesMapper mapper;
    TProjectorsMapper projectorsMapper;
    TVector<NLSA::TProjectorField> headers;
    ui8 ngram;
};

class TDSSMModelWithInfo : public NNeuralNetApplier::TModel {
public:
    TDSSMModelWithInfo(const TBlob & model, TVector<NLSA::TProjectorField> modelHeaders, TVector<TString> modelOutputs, TFeaturesMapper mapper, TProjectorsMapper projectorsMapper)
        : mapper(std::move(mapper)),
        projectorsMapper(std::move(projectorsMapper)),
        outputs(std::move(modelOutputs)),
        headers(std::move(modelHeaders)) {
        Load(model);
    }

    const TVector<NLSA::TProjectorField>& GetHeaders() const { return headers; };
    const TVector<TString>& GetOutputs() const { return outputs; };

    TFeaturesMapper mapper;
    TProjectorsMapper projectorsMapper;
private:
    TVector<TString> inputs;
    TVector<TString> outputs;
    TVector<NLSA::TProjectorField> headers;
};

class TMailTabModelWithInfo : public NMailTabs::TMailTabsModel{
public:
    TMailTabModelWithInfo(const TFsPath& root, const NConfig::TConfig& config);
    THashMap<NLSA::TTabTheme, TString> mapper;
};

using TTabModels = THashMap<NLSA::TTabTheme, TFullModel>;


struct TModelTraits{
    TTabModels modelsByName;
};

using TModelTraitsByName = THashMap<TString, TModelTraits>;

class TGodObject {
public:

    const NLSA::TDictionary & GetDictionary() const { return w2vDictionary; }

    TVector<const NLSA::TW2VTrait *> GetCoordinatesByIds(const TVector<TString>& tokens) const;
    TVector<const NLSA::TW2VViewTrait *> GetComplCoordinatesByIds(const TVector<TString>& tokens) const;
    TVector<NLSA::TDistance::TResult> GetNearestCompl(const TVector<const NLSA::TW2VViewTrait *>& traits) const;
    THashMap<TString, NLSA::TResolutionContext> GetVWResolution(const NLSA::TRequestData &requestData) const;
    THashMap<TString, NLSA::TResolutionContext> GetDSSMResolution(const NLSA::TRequestData &requestData) const;
    TVector<TString> GetNGTabResolution(const NLSA::TRequestData &requestData) const;
    THashMap<TString, double> GetVWBodyWeight(const TString & word) const;

    TVector<float> Text2Vec(const TStringBuf text) const;

    static const size_t clustersNum = 3;
    TChain Solve(const NLSA::TMatrix & docCoordinate) const;

    const TFullModel & GetCheckFormModel() const { return catboostModelForCheckForm; }
    const auto & GetTabTraitsByName() const { return tabTraitsByName; }

    explicit TGodObject(const NConfig::TConfig& config);
    ~TGodObject();

private:
    THolder<IChildOptimizer> optimizer;
    THolder<ISolver> solver;

    NLSA::TDictionary w2vDictionary;
    NLSA::TViewDictionary w2vComplsDictionary;
    NLSA::TThemeTree themes;

    THashMap<TString, const TVWModelWithInfo> vwModelsById;
    THashMap<TString, const TDSSMModelWithInfo> dssmModelsById;

    TFullModel catboostModelForCheckForm;

    TModelTraitsByName tabTraitsByName;

    THolder<NLSA::THnswIndex> hnswComplIndex;

    THashMap<TString, const TMailTabModelWithInfo> ngTabModels;
};


//****************************************************************************************************************************************

