#pragma once


#include "solver.h"
#include "../data/matrix.h"
#include "../data/theme_tree.h"
#include <algorithm>

class TGreedySolver : public ISolver{
public:

    TChain Solve(const IChildOptimizer & solver, const NLSA::TMatrix & docCoordinate) const override{

        const NLSA::TTheme * node = tree.GetRoot();

        TChain chain;

        while(!node->children.empty()) {

            const auto & weightedChildren = solver.Solve(*node, docCoordinate);

            auto it = std::max_element(weightedChildren.cbegin(), weightedChildren.cend());

            node = tree.GetThemeById(it->child);

            chain.emplace_back(node, it->weight);
        }

        return chain;
    }

    explicit TGreedySolver(const NLSA::TThemeTree & tree) : tree(tree) {}
private:

private:
    const NLSA::TThemeTree & tree;
};
