
#include <mail/so/spamstop/tools/lsa/data/matrix.h>
#include "mlp_solver.h"

TWeigtedChildren TMLPSolver::Solve(const NLSA::TTheme & theme, const NLSA::TMatrix & docCoordinate) const {

    auto webIt = ml.find(theme.themeId);

    if(webIt == ml.cend() || theme.children.size() == 1)
    {
        return TWeigtedChildren{{theme.children.front(), theme.children.size() == 1 ? -2.0 : -1.0}};
    }
    else
    {
        const auto & web = webIt->second;

        const TVector<double> & weights = web.Process(docCoordinate);

        TWeigtedChildren weigtedChildren;
        weigtedChildren.reserve(weights.size());
        for(size_t childIndex = 0; childIndex < weights.size(); childIndex++) {
            weigtedChildren.emplace_back(theme.children[childIndex], weights[childIndex]);
        }
        return weigtedChildren;
    }
}

TMLPSolver::TMLPSolver(NLSA::TMlByIds ml) : ml(std::move(ml)) {}

TMLPSolver::~TMLPSolver() = default;
