#pragma once

#include <util/generic/vector.h>
#include "../data/theme.h"
#include "../data/matrix.h"

#include <utility>


struct TBest {
    const NLSA::TTheme * theme{};
    double weight;
    TBest(const NLSA::TTheme * theme, double weight) : theme(theme), weight(weight) {}
};
using TChain = TVector<TBest>;

struct TWeigtedChain {
    TChain chain{};
    double weight;

    bool operator<(const TWeigtedChain & wc) const {
        return weight/chain.size() < wc.weight/wc.chain.size();
    }

    TWeigtedChain(TChain chain, double weight) : chain(std::move(chain)), weight(weight) {}
};

struct TWeigtedChild {
    int child;
    double weight;

    bool operator<(const TWeigtedChild & c) const {
        return weight < c.weight;
    }

    TWeigtedChild(int child, double weight) : child(child), weight(weight) {}
};
using TWeigtedChildren = TVector<TWeigtedChild>;

class IChildOptimizer{
public:


    virtual TWeigtedChildren Solve(const NLSA::TTheme & theme, const NLSA::TMatrix & docCoordinate) const = 0;

    virtual ~IChildOptimizer() = default;
};

class ISolver{
public:


    virtual TChain Solve(const IChildOptimizer & solver, const NLSA::TMatrix & docCoordinate) const = 0;
    virtual ~ISolver() = default;
};
