#pragma once

#include <mail/so/spamstop/tools/so-common/prof.h>
#include <mail/so/spamstop/tools/text2shingles/lib/text2shingles.h>
#include <mail/so/spamstop/tools/simple_shingler/handler_server.h>
#include <catboost/libs/cat_feature/cat_feature.h>
#include "god_object.h"


class TW2VHandler : public THandlerFunctor {
public:
    void Reply(THandleContext && handleContext, void*) override {

        const auto & cgi = handleContext.cgiParameters;

        auto textIt = cgi.find("text");

        if(textIt == cgi.cend()) {
            THttpResponse(HTTP_BAD_REQUEST).SetContent("cannot find text param").OutTo(handleContext.output);
            return;
        }

        const bool lemmatize = [&cgi]{
            auto lemmatizeIt = cgi.find("lemmatize");
            return lemmatizeIt != cgi.cend() && lemmatizeIt->second == "true";
        }();

        const auto shingles = NText2Shingles::Text2Shingles(textIt->second, LANG_UNK, lemmatize);

        const TGodObject& godObject = *this->godObject;
        TString res;
        {
            TStringOutput stream(res);
            NJson::TJsonWriter writer(&stream, true);

            writer.OpenArray();
            for(const auto & shingle : shingles) {
                writer.OpenMap();
                writer.Write("shingle", shingle);

                {
                    auto traitIt = godObject.GetDictionary().find(ToString(NLSA::TField::Body) + shingle);

                    if(traitIt != godObject.GetDictionary().cend()) {
                        const auto & trait = traitIt->second;

                        writer.OpenArray("coordinate");
                        for(size_t i = 0; i < static_cast<size_t>(trait.coordinate.cols()); i++)
                            writer.Write(trait.coordinate(0, i));
                        writer.CloseArray();

                        writer.Write("cluster", trait.cluster);
                    }
                }

                {
                    const auto weights = godObject.GetVWBodyWeight(shingle);

                    for(const auto & [id, weight] : weights) {
                        writer.Write("vw_" + id, weight);
                    }
                }
                writer.CloseMap();
            }
            writer.CloseArray();
        }

        THttpResponse(HTTP_OK).SetContent(std::move(res)).OutTo(handleContext.output);
    }

    TW2VHandler(TSimpleSharedPtr<const TGodObject> godObject) noexcept : godObject(std::move(godObject)) {}
    const TSimpleSharedPtr<const TGodObject> godObject;
};

